/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import javax.net.ssl.SSLEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslEngineTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslEngineTestParam;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SSLEngineTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;

public class ReferenceCountedOpenSslEngineTest
extends OpenSslEngineTest {
    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.OPENSSL_REFCNT;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.OPENSSL_REFCNT;
    }

    @Override
    protected void cleanupClientSslContext(SslContext ctx) {
        ReferenceCountUtil.release((Object)ctx);
    }

    @Override
    protected void cleanupClientSslEngine(SSLEngine engine) {
        ReferenceCountUtil.release((Object)this.unwrapEngine(engine));
    }

    @Override
    protected void cleanupServerSslContext(SslContext ctx) {
        ReferenceCountUtil.release((Object)ctx);
    }

    @Override
    protected void cleanupServerSslEngine(SSLEngine engine) {
        ReferenceCountUtil.release((Object)this.unwrapEngine(engine));
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testNotLeakOnException(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                ReferenceCountedOpenSslEngineTest.this.clientSslCtx.newEngine(null);
            }
        });
    }

    @Override
    protected SslContext wrapContext(SSLEngineTest.SSLEngineTestParam param, SslContext context) {
        return OpenSslEngineTestParam.wrapContext(param, context);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void parentContextIsRetainedByChildEngines(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        SslContext clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine engine = clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertEquals((int)ReferenceCountUtil.refCnt((Object)clientSslCtx), (int)2);
        this.cleanupClientSslContext(clientSslCtx);
        Assertions.assertEquals((int)ReferenceCountUtil.refCnt((Object)clientSslCtx), (int)1);
        this.cleanupClientSslEngine(engine);
        Assertions.assertEquals((int)ReferenceCountUtil.refCnt((Object)clientSslCtx), (int)0);
    }
}

