/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslUtils;

public class SslUtilsTest {
    @Test
    public void testPacketLength() throws SSLException, NoSuchAlgorithmException {
        SSLEngine engineLE = SslUtilsTest.newEngine();
        SSLEngine engineBE = SslUtilsTest.newEngine();
        ByteBuffer empty = ByteBuffer.allocate(0);
        ByteBuffer cTOsLE = ByteBuffer.allocate(17408).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer cTOsBE = ByteBuffer.allocate(17408);
        Assertions.assertTrue((engineLE.wrap(empty, cTOsLE).bytesProduced() > 0 ? 1 : 0) != 0);
        cTOsLE.flip();
        Assertions.assertTrue((engineBE.wrap(empty, cTOsBE).bytesProduced() > 0 ? 1 : 0) != 0);
        cTOsBE.flip();
        ByteBuf bufferLE = Unpooled.buffer().order(ByteOrder.LITTLE_ENDIAN).writeBytes(cTOsLE);
        ByteBuf bufferBE = Unpooled.buffer().writeBytes(cTOsBE);
        Assertions.assertEquals((int)SslUtils.getEncryptedPacketLength((ByteBuf)bufferBE, (int)0, (boolean)true), (int)SslUtils.getEncryptedPacketLength((ByteBuf)bufferLE, (int)0, (boolean)true));
        Assertions.assertEquals((int)SslUtils.getEncryptedPacketLength((ByteBuffer[])new ByteBuffer[]{bufferBE.nioBuffer()}, (int)0), (int)SslUtils.getEncryptedPacketLength((ByteBuffer[])new ByteBuffer[]{bufferLE.nioBuffer().order(ByteOrder.LITTLE_ENDIAN)}, (int)0));
    }

    private static SSLEngine newEngine() throws SSLException, NoSuchAlgorithmException {
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(true);
        engine.beginHandshake();
        return engine;
    }

    @Test
    public void testIsTLSv13Cipher() {
        Assertions.assertTrue((boolean)SslUtils.isTLSv13Cipher((String)"TLS_AES_128_GCM_SHA256"));
        Assertions.assertTrue((boolean)SslUtils.isTLSv13Cipher((String)"TLS_AES_256_GCM_SHA384"));
        Assertions.assertTrue((boolean)SslUtils.isTLSv13Cipher((String)"TLS_CHACHA20_POLY1305_SHA256"));
        Assertions.assertTrue((boolean)SslUtils.isTLSv13Cipher((String)"TLS_AES_128_CCM_SHA256"));
        Assertions.assertTrue((boolean)SslUtils.isTLSv13Cipher((String)"TLS_AES_128_CCM_8_SHA256"));
        Assertions.assertFalse((boolean)SslUtils.isTLSv13Cipher((String)"TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"));
    }

    @Test
    public void shouldGetPacketLengthOfGmsslProtocolFromByteBuf() {
        int bodyLength = 65;
        ByteBuf buf = Unpooled.buffer().writeByte(22).writeShort(257).writeShort(bodyLength);
        int packetLength = SslUtils.getEncryptedPacketLength((ByteBuf)buf, (int)0, (boolean)true);
        Assertions.assertEquals((int)(bodyLength + 5), (int)packetLength);
        buf.release();
    }

    @Test
    public void shouldGetPacketLengthOfGmsslProtocolFromByteBuffer() {
        int bodyLength = 65;
        ByteBuf buf = Unpooled.buffer().writeByte(22).writeShort(257).writeShort(bodyLength);
        int packetLength = SslUtils.getEncryptedPacketLength((ByteBuffer[])new ByteBuffer[]{buf.nioBuffer()}, (int)0);
        Assertions.assertEquals((int)(bodyLength + 5), (int)packetLength);
        buf.release();
    }

    @ParameterizedTest
    @ValueSource(ints={-257, -259, -260})
    public void shouldGetPacketLengthOfDtlsRecordFromByteBuf(int dtlsVersion) {
        int bodyLength = 65;
        ByteBuf buf = Unpooled.buffer().writeByte(22).writeShort(dtlsVersion).writeShort(0).writeBytes(new byte[6]).writeShort(bodyLength);
        int packetLength = SslUtils.getEncryptedPacketLength((ByteBuf)buf, (int)0, (boolean)true);
        Assertions.assertEquals((int)78, (int)packetLength);
        buf.release();
    }

    @ParameterizedTest
    @ValueSource(ints={-257, -259, -260})
    public void shouldGetPacketLengthOfFirstDtlsRecordFromByteBuf(int dtlsVersion) {
        int bodyLength = 65;
        ByteBuf buf = Unpooled.buffer().writeByte(22).writeShort(dtlsVersion).writeShort(0).writeBytes(new byte[6]).writeShort(bodyLength).writeBytes(new byte[65]).writeByte(22).writeShort(dtlsVersion).writeShort(0).writeBytes(new byte[6]).writeShort(bodyLength).writeBytes(new byte[65]);
        int packetLength = SslUtils.getEncryptedPacketLength((ByteBuf)buf, (int)0, (boolean)true);
        Assertions.assertEquals((int)78, (int)packetLength);
        buf.release();
    }

    @ParameterizedTest
    @ValueSource(ints={-257, -259, -260})
    public void shouldSupportIncompletePackets(int dtlsVersion) {
        ByteBuf buf = Unpooled.buffer().writeByte(22).writeShort(dtlsVersion).writeShort(0).writeBytes(new byte[6]).writeByte(0);
        int packetLength = SslUtils.getEncryptedPacketLength((ByteBuf)buf, (int)0, (boolean)true);
        Assertions.assertEquals((int)-1, (int)packetLength);
        buf.release();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void probeForSSLv2(boolean probeSSLv2) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{48, -126, 12, 72, 2, 1, 1, 1});
        int packetLength = SslUtils.getEncryptedPacketLength((ByteBuf)buf, (int)0, (boolean)probeSSLv2);
        if (probeSSLv2) {
            Assertions.assertNotEquals((int)-2, (int)packetLength);
        } else {
            Assertions.assertEquals((int)-2, (int)packetLength);
        }
        buf.release();
    }

    @Test
    public void testValidHostNameForSni() {
        Assertions.assertFalse((boolean)SslUtils.isValidHostNameForSNI((String)"/test.de"), (String)"SNI domain can't start with /");
        Assertions.assertFalse((boolean)SslUtils.isValidHostNameForSNI((String)"test.de."), (String)"SNI domain can't end with a dot/");
        Assertions.assertTrue((boolean)SslUtils.isValidHostNameForSNI((String)"test.de"));
        Assertions.assertFalse((boolean)SslUtils.isValidHostNameForSNI((String)"test"), (String)"SNI has to be FQDN");
    }
}

