/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util;

import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.LazyJavaxX509Certificate;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;

public class LazyJavaxX509CertificateTest {
    private static final String CERTIFICATE = "-----BEGIN CERTIFICATE-----\nMIIEITCCAwmgAwIBAgIUaLL8vLOhWLCLXVHEJqXJhfmsTB8wDQYJKoZIhvcNAQEL\nBQAwgawxCzAJBgNVBAYTAlVTMRYwFAYDVQQIDA1NYXNzYWNodXNldHRzMRIwEAYD\nVQQHDAlDYW1icmlkZ2UxGDAWBgNVBAoMD25ldHR5IHRlc3QgY2FzZTEYMBYGA1UE\nCwwPbmV0dHkgdGVzdCBjYXNlMRgwFgYDVQQDDA9uZXR0eSB0ZXN0IGNhc2UxIzAh\nBgkqhkiG9w0BCQEWFGNjb25uZWxsQGh1YnNwb3QuY29tMB4XDTI0MDEyMTE5MzMy\nMFoXDTI1MDEyMDE5MzMyMFowgawxCzAJBgNVBAYTAlVTMRYwFAYDVQQIDA1NYXNz\nYWNodXNldHRzMRIwEAYDVQQHDAlDYW1icmlkZ2UxGDAWBgNVBAoMD25ldHR5IHRl\nc3QgY2FzZTEYMBYGA1UECwwPbmV0dHkgdGVzdCBjYXNlMRgwFgYDVQQDDA9uZXR0\neSB0ZXN0IGNhc2UxIzAhBgkqhkiG9w0BCQEWFGNjb25uZWxsQGh1YnNwb3QuY29t\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAy+qzEZpQMjVdLj0siUcG\ny8LIHOW4S+tgHIKFkF865qWq6FVGbROe2Z0f5W6yIamZkdxzptT0iv+8S5okNNeW\n2NbsN/HNJIRtWfxku1Jh1gBqSkAYIjXyq7+20hIaJTzzxqike9M/Lc14EGb33Ja/\nkDPRV3UtiM3Ntf3eALXKbrWptkbgQngCaTgtfg8IkMAEpP270wZ9fW0lDHv3NPPt\nZt0QSJzWSqWfu+l4ayvcUQYyNJesx9YmTHSJu69lvT4QApoX8FEiHfNCJ28R50CS\naIgOpCWUvkH7rqx0p9q393uJRS/S6RlLbU30xUN1fNrVmP/XAapfy+R0PSgiUi8o\nEQIDAQABozkwNzAWBgNVHRIEDzANggt3d3cuZm9vLmNvbTAdBgNVHQ4EFgQUl4FD\nY8jJ/JHJR68YqPsGUjUJuwgwDQYJKoZIhvcNAQELBQADggEBADVzivYz2M0qsWUc\njXjCHymwTIr+7ud10um53FbYEAfKWsIY8Pp35fKpFzUwc5wVdCnLU86K/YMKRzNB\nzL2Auow3PJFRvXecOv7dWxNlNneLDcwbVrdNRu6nQXmZUgyz0oUKuJbF+JGtI+7W\nkRw7yhBfki+UCSQWeDqvaWzgmA4Us0N8NFq3euAs4xFbMMPMQWrT9Z7DGchCeRiB\ndkQBvh88vbR3v2Saq14W4Wt5rj2++vXWGQSeAQL6nGbOwc3ohW6isNNV0eGQQTmS\nkhS2d/JDZq2XL5RGexf3CA6YYzWiTr9YZHNjuobvLH7mVnA2c8n6Zty/UhfnuK1x\nJbkleFk=\n-----END CERTIFICATE-----";

    @Test
    public void testLazyX509Certificate() throws Exception {
        X509Certificate x509Certificate;
        try {
            x509Certificate = X509Certificate.getInstance(CERTIFICATE.getBytes(CharsetUtil.UTF_8));
        }
        catch (CertificateException e) {
            Assumptions.abort((String)("JDK does not support creating " + X509Certificate.class));
            return;
        }
        LazyJavaxX509Certificate lazyX509Certificate = new LazyJavaxX509Certificate(CERTIFICATE.getBytes(CharsetUtil.UTF_8));
        Assertions.assertEquals((int)x509Certificate.getVersion(), (int)lazyX509Certificate.getVersion());
        Assertions.assertEquals((Object)x509Certificate.getSerialNumber(), (Object)lazyX509Certificate.getSerialNumber());
        Assertions.assertEquals((Object)x509Certificate.getIssuerDN(), (Object)lazyX509Certificate.getIssuerDN());
        Assertions.assertEquals((Object)x509Certificate.getSubjectDN(), (Object)lazyX509Certificate.getSubjectDN());
        Assertions.assertEquals((Object)x509Certificate.getNotBefore(), (Object)lazyX509Certificate.getNotBefore());
        Assertions.assertEquals((Object)x509Certificate.getNotAfter(), (Object)lazyX509Certificate.getNotAfter());
        Assertions.assertEquals((Object)x509Certificate.getSigAlgName(), (Object)lazyX509Certificate.getSigAlgName());
        Assertions.assertEquals((Object)x509Certificate.getSigAlgOID(), (Object)lazyX509Certificate.getSigAlgOID());
        Assertions.assertEquals((Object)x509Certificate.getSigAlgParams(), (Object)lazyX509Certificate.getSigAlgParams());
    }
}

