/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.resolver;

import com.google.common.collect.Maps;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.driver.internal.shaded.io.netty.resolver.DefaultHostsFileEntriesResolver;
import org.neo4j.driver.internal.shaded.io.netty.resolver.HostsFileEntriesProvider;
import org.neo4j.driver.internal.shaded.io.netty.resolver.ResolvedAddressTypes;
import org.neo4j.driver.internal.shaded.io.netty.util.NetUtil;

public class DefaultHostsFileEntriesResolverTest {
    private static final Map<String, List<InetAddress>> LOCALHOST_V4_ADDRESSES = Collections.singletonMap("localhost", Collections.singletonList(NetUtil.LOCALHOST4));
    private static final Map<String, List<InetAddress>> LOCALHOST_V6_ADDRESSES = Collections.singletonMap("localhost", Collections.singletonList(NetUtil.LOCALHOST6));
    private static final long ENTRIES_TTL = TimeUnit.MINUTES.toNanos(1L);

    @Test
    public void testCaseInsensitivity() {
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver();
        Assertions.assertEquals((Object)resolver.normalize("localhost"), (Object)resolver.normalize("LOCALHOST"));
    }

    @Test
    public void shouldntFindWhenAddressTypeDoesntMatch() {
        HostsFileEntriesProvider.Parser parser = this.givenHostsParserWith(LOCALHOST_V4_ADDRESSES, Collections.<String, List<InetAddress>>emptyMap());
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(parser, ENTRIES_TTL);
        InetAddress address = resolver.address("localhost", ResolvedAddressTypes.IPV6_ONLY);
        Assertions.assertNull((Object)address, (String)"Should pick an IPv6 address");
    }

    @Test
    public void shouldPickIpv4WhenBothAreDefinedButIpv4IsPreferred() {
        HostsFileEntriesProvider.Parser parser = this.givenHostsParserWith(LOCALHOST_V4_ADDRESSES, LOCALHOST_V6_ADDRESSES);
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(parser, ENTRIES_TTL);
        InetAddress address = resolver.address("localhost", ResolvedAddressTypes.IPV4_PREFERRED);
        MatcherAssert.assertThat((String)"Should pick an IPv4 address", (Object)address, (Matcher)Matchers.instanceOf(Inet4Address.class));
    }

    @Test
    public void shouldPickIpv6WhenBothAreDefinedButIpv6IsPreferred() {
        HostsFileEntriesProvider.Parser parser = this.givenHostsParserWith(LOCALHOST_V4_ADDRESSES, LOCALHOST_V6_ADDRESSES);
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(parser, ENTRIES_TTL);
        InetAddress address = resolver.address("localhost", ResolvedAddressTypes.IPV6_PREFERRED);
        MatcherAssert.assertThat((String)"Should pick an IPv6 address", (Object)address, (Matcher)Matchers.instanceOf(Inet6Address.class));
    }

    @Test
    public void shouldntFindWhenAddressesTypeDoesntMatch() {
        HostsFileEntriesProvider.Parser parser = this.givenHostsParserWith(LOCALHOST_V4_ADDRESSES, Collections.<String, List<InetAddress>>emptyMap());
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(parser, ENTRIES_TTL);
        List addresses = resolver.addresses("localhost", ResolvedAddressTypes.IPV6_ONLY);
        Assertions.assertNull((Object)addresses, (String)"Should pick an IPv6 address");
    }

    @Test
    public void shouldPickIpv4FirstWhenBothAreDefinedButIpv4IsPreferred() {
        HostsFileEntriesProvider.Parser parser = this.givenHostsParserWith(LOCALHOST_V4_ADDRESSES, LOCALHOST_V6_ADDRESSES);
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(parser, ENTRIES_TTL);
        List addresses = resolver.addresses("localhost", ResolvedAddressTypes.IPV4_PREFERRED);
        Assertions.assertNotNull((Object)addresses);
        Assertions.assertEquals((int)2, (int)addresses.size());
        MatcherAssert.assertThat((String)"Should pick an IPv4 address", addresses.get(0), (Matcher)Matchers.instanceOf(Inet4Address.class));
        MatcherAssert.assertThat((String)"Should pick an IPv6 address", addresses.get(1), (Matcher)Matchers.instanceOf(Inet6Address.class));
    }

    @Test
    public void shouldPickIpv6FirstWhenBothAreDefinedButIpv6IsPreferred() {
        HostsFileEntriesProvider.Parser parser = this.givenHostsParserWith(LOCALHOST_V4_ADDRESSES, LOCALHOST_V6_ADDRESSES);
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(parser, ENTRIES_TTL);
        List addresses = resolver.addresses("localhost", ResolvedAddressTypes.IPV6_PREFERRED);
        Assertions.assertNotNull((Object)addresses);
        Assertions.assertEquals((int)2, (int)addresses.size());
        MatcherAssert.assertThat((String)"Should pick an IPv6 address", addresses.get(0), (Matcher)Matchers.instanceOf(Inet6Address.class));
        MatcherAssert.assertThat((String)"Should pick an IPv4 address", addresses.get(1), (Matcher)Matchers.instanceOf(Inet4Address.class));
    }

    @Test
    public void shouldNotRefreshHostsFileContentBeforeRefreshIntervalElapsed() {
        HashMap v4Addresses = Maps.newHashMap(LOCALHOST_V4_ADDRESSES);
        HashMap v6Addresses = Maps.newHashMap(LOCALHOST_V6_ADDRESSES);
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(this.givenHostsParserWith(v4Addresses, v6Addresses), ENTRIES_TTL);
        String newHost = UUID.randomUUID().toString();
        v4Addresses.put(newHost, Collections.singletonList(NetUtil.LOCALHOST4));
        v6Addresses.put(newHost, Collections.singletonList(NetUtil.LOCALHOST6));
        Assertions.assertNull((Object)resolver.address(newHost, ResolvedAddressTypes.IPV4_ONLY));
        Assertions.assertNull((Object)resolver.address(newHost, ResolvedAddressTypes.IPV6_ONLY));
    }

    @Test
    public void shouldRefreshHostsFileContentAfterRefreshInterval() throws Exception {
        HashMap v4Addresses = Maps.newHashMap(LOCALHOST_V4_ADDRESSES);
        HashMap v6Addresses = Maps.newHashMap(LOCALHOST_V6_ADDRESSES);
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(this.givenHostsParserWith(v4Addresses, v6Addresses), 1L);
        String newHost = UUID.randomUUID().toString();
        InetAddress address = resolver.address(newHost, ResolvedAddressTypes.IPV6_ONLY);
        Assertions.assertNull((Object)address);
        Thread.sleep(1L);
        v4Addresses.put(newHost, Collections.singletonList(NetUtil.LOCALHOST4));
        v6Addresses.put(newHost, Collections.singletonList(NetUtil.LOCALHOST6));
        Assertions.assertEquals((Object)NetUtil.LOCALHOST4, (Object)resolver.address(newHost, ResolvedAddressTypes.IPV4_ONLY));
        Assertions.assertEquals((Object)NetUtil.LOCALHOST6, (Object)resolver.address(newHost, ResolvedAddressTypes.IPV6_ONLY));
    }

    private HostsFileEntriesProvider.Parser givenHostsParserWith(final Map<String, List<InetAddress>> inet4Entries, final Map<String, List<InetAddress>> inet6Entries) {
        HostsFileEntriesProvider.Parser mockParser = (HostsFileEntriesProvider.Parser)Mockito.mock(HostsFileEntriesProvider.Parser.class);
        Answer<HostsFileEntriesProvider> mockedAnswer = new Answer<HostsFileEntriesProvider>(){

            public HostsFileEntriesProvider answer(InvocationOnMock invocation) {
                return new HostsFileEntriesProvider(inet4Entries, inet6Entries);
            }
        };
        Mockito.when((Object)mockParser.parseSilently()).thenAnswer((Answer)mockedAnswer);
        Mockito.when((Object)mockParser.parseSilently(new Charset[]{(Charset)Mockito.any(Charset.class)})).thenAnswer((Answer)mockedAnswer);
        return mockParser;
    }
}

