/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.util.DomainWildcardMappingBuilder;
import org.neo4j.driver.internal.shaded.io.netty.util.Mapping;

public class DomainWildcardMappingBuilderTest {
    @Test
    public void testNullDefaultValue() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DomainWildcardMappingBuilder(null);
            }
        });
    }

    @Test
    public void testNullDomainNamePatternsAreForbidden() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DomainWildcardMappingBuilder((Object)"NotFound").add(null, (Object)"Some value");
            }
        });
    }

    @Test
    public void testNullValuesAreForbidden() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DomainWildcardMappingBuilder((Object)"NotFound").add("Some key", null);
            }
        });
    }

    @Test
    public void testDefaultValue() {
        Mapping mapping = new DomainWildcardMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").build();
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map((Object)"not-existing"));
    }

    @Test
    public void testStrictEquality() {
        Mapping mapping = new DomainWildcardMappingBuilder((Object)"NotFound").add("netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").build();
        Assertions.assertEquals((Object)"Netty", (Object)mapping.map((Object)"netty.io"));
        Assertions.assertEquals((Object)"Netty-Downloads", (Object)mapping.map((Object)"downloads.netty.io"));
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map((Object)"x.y.z.netty.io"));
    }

    @Test
    public void testWildcardMatchesNotAnyPrefix() {
        Mapping mapping = new DomainWildcardMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").build();
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map((Object)"netty.io"));
        Assertions.assertEquals((Object)"Netty", (Object)mapping.map((Object)"downloads.netty.io"));
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map((Object)"x.y.z.netty.io"));
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map((Object)"netty.io.x"));
    }

    @Test
    public void testExactMatchWins() {
        Assertions.assertEquals((Object)"Netty-Downloads", (Object)new DomainWildcardMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").build().map((Object)"downloads.netty.io"));
        Assertions.assertEquals((Object)"Netty-Downloads", (Object)new DomainWildcardMappingBuilder((Object)"NotFound").add("downloads.netty.io", (Object)"Netty-Downloads").add("*.netty.io", (Object)"Netty").build().map((Object)"downloads.netty.io"));
    }

    @Test
    public void testToString() {
        Mapping mapping = new DomainWildcardMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Download").build();
        Assertions.assertEquals((Object)"ImmutableDomainWildcardMapping(default: NotFound, map: {*.netty.io=Netty, downloads.netty.io=Netty-Download})", (Object)mapping.toString());
    }
}

