/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.driver.internal.shaded.io.netty.util.ResourceLeakDetector;
import org.neo4j.driver.internal.shaded.io.netty.util.ResourceLeakHint;
import org.neo4j.driver.internal.shaded.io.netty.util.ResourceLeakTracker;

public class ResourceLeakDetectorTest {
    private static volatile int sink;

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testConcurrentUsage() throws Throwable {
        final AtomicBoolean finished = new AtomicBoolean();
        final AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        Thread[] threads = new Thread[50];
        final CyclicBarrier barrier = new CyclicBarrier(threads.length);
        for (int i = 0; i < threads.length; ++i) {
            Thread t;
            threads[i] = t = new Thread(new Runnable(){
                final Queue<LeakAwareResource> resources = new ArrayDeque<LeakAwareResource>(100);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        barrier.await();
                        for (int b = 0; b < 1000 && !finished.get(); ++b) {
                            for (int a = 0; a < 100; ++a) {
                                DefaultResource resource = new DefaultResource();
                                ResourceLeakTracker leak = DefaultResource.detector.track(resource);
                                LeakAwareResource leakAwareResource = new LeakAwareResource(resource, (ResourceLeakTracker<Resource>)leak);
                                this.resources.add(leakAwareResource);
                            }
                            if (!this.closeResources(true)) continue;
                            finished.set(true);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable e) {
                        error.compareAndSet(null, e);
                    }
                    finally {
                        this.closeResources(false);
                    }
                }

                private boolean closeResources(boolean checkClosed) {
                    boolean closed;
                    do {
                        LeakAwareResource r;
                        if ((r = this.resources.poll()) == null) {
                            return false;
                        }
                        closed = r.close();
                    } while (!checkClosed || closed);
                    error.compareAndSet(null, new AssertionError((Object)"ResourceLeak.close() returned 'false' but expected 'true'"));
                    return true;
                }
            });
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        DefaultResource.detector.assertNoErrors();
        ResourceLeakDetectorTest.assertNoErrors(error);
    }

    @Timeout(value=10L)
    @Test
    public void testLeakSetupHints() throws Throwable {
        DefaultResource.detectorWithSetupHint.initialise();
        ResourceLeakDetectorTest.leakResource();
        do {
            System.gc();
            DefaultResource resource2 = new DefaultResource();
            DefaultResource.detectorWithSetupHint.track(resource2).close((Object)resource2);
            for (int i = 0; i < 1000; ++i) {
                sink = System.identityHashCode(new byte[10000]);
            }
        } while (DefaultResource.detectorWithSetupHint.getLeaksFound() < 1 && !Thread.interrupted());
        Assertions.assertThat((int)DefaultResource.detectorWithSetupHint.getLeaksFound()).isOne();
        DefaultResource.detectorWithSetupHint.assertNoErrors();
    }

    @Timeout(value=10L)
    @Test
    public void testLeakBrokenHint() throws Throwable {
        DefaultResource.detectorWithSetupHint.initialise();
        DefaultResource.detectorWithSetupHint.failOnUntraced = false;
        DefaultResource.detectorWithSetupHint.initialHint = new ResourceLeakHint(){

            public String toHintString() {
                throw new RuntimeException("expected failure");
            }
        };
        try {
            ResourceLeakDetectorTest.leakResource();
            Assertions.fail((String)"expected failure");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("expected failure");
        }
        DefaultResource.detectorWithSetupHint.initialHint = DefaultResource.detectorWithSetupHint.canaryString;
        do {
            System.gc();
            DefaultResource resource2 = new DefaultResource();
            DefaultResource.detectorWithSetupHint.track(resource2).close((Object)resource2);
            for (int i = 0; i < 1000; ++i) {
                sink = System.identityHashCode(new byte[10000]);
            }
        } while (DefaultResource.detectorWithSetupHint.getLeaksFound() < 1 && !Thread.interrupted());
        Assertions.assertThat((int)DefaultResource.detectorWithSetupHint.getLeaksFound()).isOne();
        DefaultResource.detectorWithSetupHint.assertNoErrors();
    }

    private static void leakResource() {
        DefaultResource resource = new DefaultResource();
        DefaultResource.detectorWithSetupHint.track(resource);
    }

    private static void assertNoErrors(AtomicReference<Throwable> ref) throws Throwable {
        Throwable error = ref.get();
        if (error != null) {
            throw error;
        }
    }

    private static final class CreationRecordLeakDetector<T>
    extends ResourceLeakDetector<T> {
        String canaryString;
        Object initialHint;
        boolean failOnUntraced = true;
        private final AtomicReference<Throwable> error = new AtomicReference();
        private final AtomicInteger leaksFound = new AtomicInteger(0);

        CreationRecordLeakDetector(Class<?> resourceType, int samplingInterval) {
            super(resourceType, samplingInterval);
        }

        public void initialise() {
            this.canaryString = "creation-canary-" + UUID.randomUUID();
            this.initialHint = this.canaryString;
            this.leaksFound.set(0);
        }

        protected boolean needReport() {
            return true;
        }

        protected void reportTracedLeak(String resourceType, String records) {
            if (!records.contains(this.canaryString)) {
                this.reportError(new AssertionError((Object)"Leak records did not contain canary string"));
            }
            this.leaksFound.incrementAndGet();
        }

        protected void reportUntracedLeak(String resourceType) {
            if (this.failOnUntraced) {
                this.reportError(new AssertionError((Object)"Got untraced leak w/o canary string"));
            }
            this.leaksFound.incrementAndGet();
        }

        private void reportError(AssertionError cause) {
            this.error.compareAndSet(null, (Throwable)((Object)cause));
        }

        protected Object getInitialHint(String resourceType) {
            return this.initialHint;
        }

        int getLeaksFound() {
            return this.leaksFound.get();
        }

        void assertNoErrors() throws Throwable {
            ResourceLeakDetectorTest.assertNoErrors(this.error);
        }
    }

    private static final class TestResourceLeakDetector<T>
    extends ResourceLeakDetector<T> {
        private final AtomicReference<Throwable> error = new AtomicReference();

        TestResourceLeakDetector(Class<?> resourceType, int samplingInterval, long maxActive) {
            super(resourceType, samplingInterval, maxActive);
        }

        protected void reportTracedLeak(String resourceType, String records) {
            this.reportError(new AssertionError((Object)("Leak reported for '" + resourceType + "':\n" + records)));
        }

        protected void reportUntracedLeak(String resourceType) {
            this.reportError(new AssertionError((Object)("Leak reported for '" + resourceType + '\'')));
        }

        protected void reportInstancesLeak(String resourceType) {
            this.reportError(new AssertionError((Object)("Leak reported for '" + resourceType + '\'')));
        }

        private void reportError(AssertionError cause) {
            this.error.compareAndSet(null, (Throwable)((Object)cause));
        }

        void assertNoErrors() throws Throwable {
            ResourceLeakDetectorTest.assertNoErrors(this.error);
        }
    }

    private static interface Resource {
        public boolean close();
    }

    private static final class DefaultResource
    implements Resource {
        static final TestResourceLeakDetector<Resource> detector = new TestResourceLeakDetector(Resource.class, 1, Integer.MAX_VALUE);
        static final CreationRecordLeakDetector<Resource> detectorWithSetupHint = new CreationRecordLeakDetector(Resource.class, 1);

        private DefaultResource() {
        }

        @Override
        public boolean close() {
            return true;
        }
    }

    private static final class LeakAwareResource
    implements Resource {
        private final Resource resource;
        private final ResourceLeakTracker<Resource> leak;

        LeakAwareResource(Resource resource, ResourceLeakTracker<Resource> leak) {
            this.resource = resource;
            this.leak = leak;
        }

        @Override
        public boolean close() {
            return this.leak.close((Object)this.resource);
        }
    }
}

