/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.collection;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.util.collection.LongObjectHashMap;
import org.neo4j.driver.internal.shaded.io.netty.util.collection.LongObjectMap;

public class LongObjectHashMapTest {
    private LongObjectHashMap<Value> map;

    @BeforeEach
    public void setup() {
        this.map = new LongObjectHashMap();
    }

    @Test
    public void iteratorRemoveShouldNotNPE() {
        this.map = new LongObjectHashMap(4, 1.0f);
        this.map.put(Long.valueOf(0L), (Object)new Value("A"));
        this.map.put(Long.valueOf(1L), (Object)new Value("B"));
        this.map.put(Long.valueOf(4L), (Object)new Value("C"));
        this.map.remove((Object)1L);
        Iterator itr = this.map.entries().iterator();
        while (itr.hasNext()) {
            LongObjectMap.PrimitiveEntry entry = (LongObjectMap.PrimitiveEntry)itr.next();
            Assertions.assertNotNull((Object)entry.key());
            Assertions.assertNotNull((Object)entry.value());
            itr.remove();
        }
        Assertions.assertTrue((boolean)this.map.isEmpty());
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void putNewMappingShouldSucceed() {
        Value v = new Value("v");
        long key = 1L;
        Assertions.assertNull((Object)this.map.put(key, (Object)v));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey(key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
        Assertions.assertEquals((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void putNewMappingShouldSucceed_mapApi() {
        Value v = new Value("v");
        Long key = 1L;
        Assertions.assertNull((Object)this.map.put(key, (Object)v));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
        Assertions.assertEquals((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldReplaceValue() {
        Value v1 = new Value("v1");
        long key = 1L;
        Assertions.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assertions.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey(key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assertions.assertEquals((Object)v2, (Object)this.map.get(key));
    }

    @Test
    public void putShouldReplaceValue_mapApi() {
        Value v1 = new Value("v1");
        Long key = 1L;
        Assertions.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assertions.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assertions.assertEquals((Object)v2, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldGrowMap() {
        for (long key = 0L; key < 255L; ++key) {
            Value v = new Value(Long.toString(key));
            Assertions.assertNull((Object)this.map.put(key, (Object)v));
            Assertions.assertEquals((long)(key + 1L), (long)this.map.size());
            Assertions.assertTrue((boolean)this.map.containsKey(key));
            Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
            Assertions.assertEquals((Object)v, (Object)this.map.get(key));
        }
    }

    @Test
    public void putShouldGrowMap_mapApi() {
        for (long key = 0L; key < 255L; ++key) {
            Long okey = key;
            Value v = new Value(Long.toString(key));
            Assertions.assertNull((Object)this.map.put(okey, (Object)v));
            Assertions.assertEquals((long)(key + 1L), (long)this.map.size());
            Assertions.assertTrue((boolean)this.map.containsKey((Object)okey));
            Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
            Assertions.assertEquals((Object)v, (Object)this.map.get((Object)okey));
        }
    }

    @Test
    public void negativeKeyShouldSucceed() {
        Value v = new Value("v");
        this.map.put(-3L, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)v, (Object)this.map.get(-3L));
    }

    @Test
    public void negativeKeyShouldSucceed_mapApi() {
        Value v = new Value("v");
        this.map.put(Long.valueOf(-3L), (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)v, (Object)this.map.get((Object)-3L));
    }

    @Test
    public void removeMissingValueShouldReturnNull() {
        Assertions.assertNull((Object)this.map.remove(1L));
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void removeMissingValueShouldReturnNull_mapApi() {
        Assertions.assertNull((Object)this.map.remove((Object)1L));
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void removeShouldReturnPreviousValue() {
        Value v = new Value("v");
        long key = 1L;
        this.map.put(key, (Object)v);
        Assertions.assertSame((Object)v, (Object)this.map.remove(key));
    }

    @Test
    public void removeShouldReturnPreviousValue_mapApi() {
        Value v = new Value("v");
        Long key = 1L;
        this.map.put(key, (Object)v);
        Assertions.assertSame((Object)v, (Object)this.map.remove((Object)key));
    }

    @Test
    public void noFreeSlotsShouldRehash() {
        for (long i = 0L; i < 10L; ++i) {
            this.map.put(i, (Object)new Value(Long.toString(i)));
            this.map.remove(i);
            Assertions.assertEquals((int)0, (int)this.map.size());
        }
        Value v = new Value("v");
        long key = 1L;
        this.map.put(key, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertSame((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void noFreeSlotsShouldRehash_mapApi() {
        for (long i = 0L; i < 10L; ++i) {
            this.map.put(i, (Object)new Value(Long.toString(i)));
            this.map.remove((Object)i);
            Assertions.assertEquals((int)0, (int)this.map.size());
        }
        Value v = new Value("v");
        Long key = 1L;
        this.map.put(key, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertSame((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putAllShouldSucceed() {
        LongObjectHashMap other = new LongObjectHashMap();
        long k1 = 1L;
        long k2 = 2L;
        long k3 = 3L;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get(k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get(k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get(k3));
    }

    @Test
    public void putAllShouldSucceed_mapApi() {
        LongObjectHashMap other = new LongObjectHashMap();
        Long k1 = 1L;
        Long k2 = 2L;
        Long k3 = 3L;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void putAllWithJavaMapShouldSucceed_mapApi() {
        HashMap<Long, Value> other = new HashMap<Long, Value>();
        Long k1 = 1L;
        Long k2 = 2L;
        Long k3 = 3L;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, v1);
        other.put(k2, v2);
        other.put(k3, v3);
        this.map.putAll(other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void clearShouldSucceed() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put(1L, (Object)v1);
        this.map.put(2L, (Object)v2);
        this.map.put(3L, (Object)v3);
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void containsValueShouldFindNull() {
        this.map.put(1L, (Object)new Value("v1"));
        this.map.put(2L, null);
        this.map.put(3L, (Object)new Value("v2"));
        Assertions.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindNull_mapApi() {
        this.map.put(Long.valueOf(1L), (Object)new Value("v1"));
        this.map.put(Long.valueOf(2L), null);
        this.map.put(Long.valueOf(3L), (Object)new Value("v2"));
        Assertions.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindInstance() {
        Value v = new Value("v1");
        this.map.put(1L, (Object)new Value("v2"));
        this.map.put(2L, (Object)new Value("v3"));
        this.map.put(3L, (Object)v);
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindInstance_mapApi() {
        Value v = new Value("v1");
        this.map.put(Long.valueOf(1L), (Object)new Value("v2"));
        this.map.put(Long.valueOf(2L), (Object)new Value("v3"));
        this.map.put(Long.valueOf(3L), (Object)v);
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindEquivalentValue() {
        this.map.put(1L, (Object)new Value("v1"));
        this.map.put(2L, (Object)new Value("v2"));
        this.map.put(3L, (Object)new Value("v3"));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueShouldFindEquivalentValue_mapApi() {
        this.map.put(Long.valueOf(1L), (Object)new Value("v1"));
        this.map.put(Long.valueOf(2L), (Object)new Value("v2"));
        this.map.put(Long.valueOf(3L), (Object)new Value("v3"));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueNotFindMissingValue() {
        this.map.put(1L, (Object)new Value("v1"));
        this.map.put(2L, (Object)new Value("v2"));
        this.map.put(3L, (Object)new Value("v3"));
        Assertions.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void containsValueNotFindMissingValue_mapApi() {
        this.map.put(Long.valueOf(1L), (Object)new Value("v1"));
        this.map.put(Long.valueOf(2L), (Object)new Value("v2"));
        this.map.put(Long.valueOf(3L), (Object)new Value("v3"));
        Assertions.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void iteratorShouldTraverseEntries() {
        long k1 = 1L;
        long k2 = 2L;
        long k3 = 3L;
        long k4 = 4L;
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet found = new HashSet();
        for (Map.Entry entry : this.map.entrySet()) {
            Assertions.assertTrue((boolean)found.add(entry.getKey()));
        }
        Assertions.assertEquals((int)3, (int)found.size());
        Assertions.assertTrue((boolean)found.contains(k1));
        Assertions.assertTrue((boolean)found.contains(k2));
        Assertions.assertTrue((boolean)found.contains(k3));
    }

    @Test
    public void keysShouldBeReturned() {
        long k1 = 1L;
        long k2 = 2L;
        long k3 = 3L;
        long k4 = 4L;
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        Set keys = this.map.keySet();
        Assertions.assertEquals((int)3, (int)keys.size());
        HashSet<Long> expected = new HashSet<Long>();
        expected.add(k1);
        expected.add(k2);
        expected.add(k3);
        HashSet<Long> found = new HashSet<Long>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            Assertions.assertTrue((boolean)found.add(key));
        }
        Assertions.assertEquals(expected, found);
    }

    @Test
    public void valuesShouldBeReturned() {
        long k1 = 1L;
        long k2 = 2L;
        long k3 = 3L;
        long k4 = 4L;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put(k1, (Object)v1);
        this.map.put(k2, (Object)v2);
        this.map.put(k3, (Object)v3);
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet<Value> expected = new HashSet<Value>();
        expected.add(v1);
        expected.add(v2);
        expected.add(v3);
        HashSet actual = new HashSet(this.map.values());
        Assertions.assertEquals(expected, actual);
    }

    @Test
    public void mapShouldSupportHashingConflicts() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                LongObjectHashMap map = new LongObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put((long)(i * mod), (Object)"");
                }
            }
        }
    }

    @Test
    public void mapShouldSupportHashingConflicts_mapApi() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                LongObjectHashMap map = new LongObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put(Long.valueOf(i * mod), (Object)"");
                }
            }
        }
    }

    @Test
    public void hashcodeEqualsTest() {
        LongObjectHashMap map1 = new LongObjectHashMap();
        LongObjectHashMap map2 = new LongObjectHashMap();
        Random rnd = new Random(0L);
        while (map1.size() < 100) {
            long key = rnd.nextInt(100);
            map1.put(key, (Object)key);
            map2.put(key, (Object)key);
        }
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertEquals((Object)map1, (Object)map2);
        Set keys = map1.keySet();
        Long removed = null;
        Iterator iter = keys.iterator();
        for (int ix = 0; iter.hasNext() && ix < 50; ++ix) {
            removed = (Long)iter.next();
        }
        map2.remove(removed);
        Assertions.assertFalse((boolean)map1.equals((Object)map2));
        map2.put(removed, (Object)removed);
        Assertions.assertEquals((Object)map1, (Object)map2);
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map2.put(100L, (Object)100L);
        Assertions.assertFalse((boolean)map1.equals((Object)map2));
        map2.clear();
        for (Long key : map1.keySet()) {
            map2.put(key, (Object)key);
        }
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertEquals((Object)map1, (Object)map2);
    }

    @Test
    public void fuzzTest() {
        long key;
        int i;
        Random rnd = new Random(0L);
        int baseSize = 1000;
        int startTableSize = 1105;
        LongObjectHashMap map = new LongObjectHashMap(startTableSize);
        HashMap<Long, Long> goodMap = new HashMap<Long, Long>();
        for (i = 0; i < baseSize / 4; ++i) {
            key = rnd.nextInt(baseSize);
            Assertions.assertEquals((Long)goodMap.put(key, key), (Long)((Long)map.put(key, (Object)key)));
            key = rnd.nextInt(baseSize) * 17;
            Assertions.assertEquals((Long)goodMap.put(key, key), (Long)((Long)map.put(key, (Object)key)));
        }
        for (i = 0; i < baseSize * 1000; ++i) {
            key = rnd.nextInt(baseSize);
            if (rnd.nextDouble() >= 0.2) {
                Assertions.assertEquals((Long)goodMap.put(key, key), (Long)((Long)map.put(key, (Object)key)));
                continue;
            }
            Assertions.assertEquals((Long)((Long)goodMap.remove(key)), (Long)((Long)map.remove(key)));
        }
        int removeSize = map.size() / 2;
        while (removeSize > 0) {
            key = rnd.nextInt(baseSize);
            boolean found = goodMap.containsKey(key);
            Assertions.assertEquals((Object)found, (Object)map.containsKey(key));
            Assertions.assertEquals((Long)((Long)goodMap.remove(key)), (Long)((Long)map.remove(key)));
            if (!found) continue;
            --removeSize;
        }
        Assertions.assertEquals((int)goodMap.size(), (int)map.size());
        Object[] goodKeys = goodMap.keySet().toArray(new Long[goodMap.size()]);
        Arrays.sort(goodKeys);
        Object[] keys = map.keySet().toArray(new Long[map.size()]);
        Arrays.sort(keys);
        for (int i2 = 0; i2 < goodKeys.length; ++i2) {
            Assertions.assertEquals((Long)goodKeys[i2], (Long)keys[i2]);
        }
        Object[] objectArray = keys;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            long key2 = (Long)objectArray[j];
            Assertions.assertEquals((Long)((Long)goodMap.remove(key2)), (Long)((Long)map.remove(key2)));
        }
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void valuesIteratorRemove() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put(1L, (Object)v1);
        this.map.put(2L, (Object)v2);
        this.map.put(3L, (Object)v3);
        Iterator it = this.map.values().iterator();
        Assertions.assertSame((Object)v1, it.next());
        Assertions.assertSame((Object)v2, it.next());
        it.remove();
        Assertions.assertSame((Object)v3, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get(1L));
        Assertions.assertNull((Object)this.map.get(2L));
        Assertions.assertSame((Object)v3, (Object)this.map.get(3L));
        it = this.map.values().iterator();
        Assertions.assertSame((Object)v1, it.next());
        Assertions.assertSame((Object)v3, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    private static class Value {
        private final String name;

        Value(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

