/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.concurrent;

import java.security.Permission;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.DefaultThreadFactory;

public class DefaultThreadFactoryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testDescendantThreadGroups() throws InterruptedException {
        SecurityManager current = System.getSecurityManager();
        boolean securityManagerSet = false;
        try {
            try {
                System.setSecurityManager(new SecurityManager(){

                    @Override
                    public void checkAccess(ThreadGroup g) {
                        ThreadGroup source = Thread.currentThread().getThreadGroup();
                        if (source != null) {
                            if (!source.parentOf(g)) {
                                throw new SecurityException("source group is not an ancestor of the target group");
                            }
                            super.checkAccess(g);
                        }
                    }

                    @Override
                    public void checkPermission(Permission perm) {
                    }
                });
            }
            catch (UnsupportedOperationException e) {
                Assumptions.assumeFalse((boolean)true, (String)"Setting SecurityManager not supported");
            }
            securityManagerSet = true;
            final AtomicReference factory = new AtomicReference();
            final AtomicInteger counter = new AtomicInteger();
            final Runnable task = new Runnable(){

                @Override
                public void run() {
                    counter.incrementAndGet();
                }
            };
            final AtomicReference interrupted = new AtomicReference();
            Thread first = new Thread(new ThreadGroup("brother"), new Runnable(){

                @Override
                public void run() {
                    factory.set(new DefaultThreadFactory("test", false, 5, null));
                    Thread t = ((DefaultThreadFactory)factory.get()).newThread(task);
                    t.start();
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {
                        interrupted.set(e);
                        Thread.currentThread().interrupt();
                    }
                }
            });
            first.start();
            first.join();
            Assertions.assertNull(interrupted.get());
            Thread second = new Thread(new ThreadGroup("sister"), new Runnable(){

                @Override
                public void run() {
                    Thread t = ((DefaultThreadFactory)factory.get()).newThread(task);
                    t.start();
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {
                        interrupted.set(e);
                        Thread.currentThread().interrupt();
                    }
                }
            });
            second.start();
            second.join();
            Assertions.assertNull(interrupted.get());
            Assertions.assertEquals((int)2, (int)counter.get());
        }
        finally {
            if (securityManagerSet) {
                System.setSecurityManager(current);
            }
        }
    }

    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testDefaultThreadFactoryStickyThreadGroupConstructor() throws InterruptedException {
        final ThreadGroup sticky = new ThreadGroup("sticky");
        DefaultThreadFactoryTest.runStickyThreadGroupTest(new Callable<DefaultThreadFactory>(){

            @Override
            public DefaultThreadFactory call() throws Exception {
                return new DefaultThreadFactory("test", false, 5, sticky);
            }
        }, sticky);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testDefaultThreadFactoryInheritsThreadGroupFromSecurityManager() throws InterruptedException {
        SecurityManager current = System.getSecurityManager();
        boolean securityManagerSet = false;
        try {
            final ThreadGroup sticky = new ThreadGroup("sticky");
            try {
                System.setSecurityManager(new SecurityManager(){

                    @Override
                    public ThreadGroup getThreadGroup() {
                        return sticky;
                    }

                    @Override
                    public void checkPermission(Permission perm) {
                    }
                });
            }
            catch (UnsupportedOperationException e) {
                Assumptions.assumeFalse((boolean)true, (String)"Setting SecurityManager not supported");
            }
            securityManagerSet = true;
            DefaultThreadFactoryTest.runStickyThreadGroupTest(new Callable<DefaultThreadFactory>(){

                @Override
                public DefaultThreadFactory call() throws Exception {
                    return new DefaultThreadFactory("test");
                }
            }, sticky);
        }
        finally {
            if (securityManagerSet) {
                System.setSecurityManager(current);
            }
        }
    }

    private static void runStickyThreadGroupTest(final Callable<DefaultThreadFactory> callable, ThreadGroup expected) throws InterruptedException {
        final AtomicReference captured = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        Thread first = new Thread(new ThreadGroup("wrong"), new Runnable(){

            @Override
            public void run() {
                DefaultThreadFactory factory;
                try {
                    factory = (DefaultThreadFactory)callable.call();
                }
                catch (Exception e) {
                    exception.set(e);
                    throw new RuntimeException(e);
                }
                Thread t = factory.newThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                captured.set(t.getThreadGroup());
            }
        });
        first.start();
        first.join();
        Assertions.assertNull(exception.get());
        Assertions.assertEquals((Object)expected, captured.get());
    }

    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testDefaultThreadFactoryNonStickyThreadGroupConstructor() throws InterruptedException {
        final AtomicReference factory = new AtomicReference();
        final AtomicReference firstCaptured = new AtomicReference();
        ThreadGroup firstGroup = new ThreadGroup("first");
        Thread first = new Thread(firstGroup, new Runnable(){

            @Override
            public void run() {
                factory.set(new DefaultThreadFactory("sticky", false, 5, null));
                Thread t = ((DefaultThreadFactory)factory.get()).newThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                firstCaptured.set(t.getThreadGroup());
            }
        });
        first.start();
        first.join();
        Assertions.assertEquals((Object)firstGroup, firstCaptured.get());
        final AtomicReference secondCaptured = new AtomicReference();
        ThreadGroup secondGroup = new ThreadGroup("second");
        Thread second = new Thread(secondGroup, new Runnable(){

            @Override
            public void run() {
                Thread t = ((DefaultThreadFactory)factory.get()).newThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                secondCaptured.set(t.getThreadGroup());
            }
        });
        second.start();
        second.join();
        Assertions.assertEquals((Object)secondGroup, secondCaptured.get());
    }

    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testCurrentThreadGroupIsUsed() throws InterruptedException {
        final AtomicReference factory = new AtomicReference();
        final AtomicReference firstCaptured = new AtomicReference();
        ThreadGroup group = new ThreadGroup("first");
        Thread first = new Thread(group, new Runnable(){

            @Override
            public void run() {
                Thread current = Thread.currentThread();
                firstCaptured.set(current.getThreadGroup());
                factory.set(new DefaultThreadFactory("sticky", false));
            }
        });
        first.start();
        first.join();
        Assertions.assertEquals((Object)group, firstCaptured.get());
        ThreadGroup currentThreadGroup = Thread.currentThread().getThreadGroup();
        Thread second = ((DefaultThreadFactory)factory.get()).newThread(new Runnable(){

            @Override
            public void run() {
            }
        });
        second.join();
        Assertions.assertEquals((Object)currentThreadGroup, (Object)currentThreadGroup);
    }
}

