/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.BoundedInputStream;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public class BoundedInputStreamTest {
    @Test
    void testBoundEnforced() throws IOException {
        byte[] bytes = new byte[64];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        final BoundedInputStream reader = new BoundedInputStream((InputStream)new ByteArrayInputStream(bytes), bytes.length - 1);
        Assertions.assertEquals((byte)bytes[0], (byte)((byte)reader.read()));
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                reader.read(new byte[64], 0, 64);
            }
        });
        reader.close();
    }

    @Test
    void testBigReadsPermittedIfUnderlyingStreamIsSmall() throws IOException {
        byte[] bytes = new byte[64];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        BoundedInputStream reader = new BoundedInputStream((InputStream)new ByteArrayInputStream(bytes), 8192);
        byte[] buffer = new byte[10000];
        reader.read(buffer, 0, 10000);
        Assertions.assertArrayEquals((byte[])bytes, (byte[])Arrays.copyOfRange(buffer, 0, 64));
        reader.close();
    }
}

