/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.DefaultPriorityQueue;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PriorityQueue;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PriorityQueueNode;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ThreadLocalRandom;

public class DefaultPriorityQueueTest {
    @Test
    public void testPoll() {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 0);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement a = new TestElement(5);
        TestElement b = new TestElement(10);
        TestElement c = new TestElement(2);
        TestElement d = new TestElement(7);
        TestElement e = new TestElement(6);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, a);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, c);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, d);
        Assertions.assertSame((Object)c, (Object)queue.peek());
        Assertions.assertSame((Object)c, (Object)queue.poll());
        Assertions.assertEquals((int)3, (int)queue.size());
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, e);
        Assertions.assertEquals((int)4, (int)queue.size());
        Assertions.assertSame((Object)a, (Object)queue.peek());
        Assertions.assertSame((Object)a, (Object)queue.poll());
        Assertions.assertEquals((int)3, (int)queue.size());
        Assertions.assertSame((Object)e, (Object)queue.peek());
        Assertions.assertSame((Object)e, (Object)queue.poll());
        Assertions.assertEquals((int)2, (int)queue.size());
        Assertions.assertSame((Object)d, (Object)queue.peek());
        Assertions.assertSame((Object)d, (Object)queue.poll());
        Assertions.assertEquals((int)1, (int)queue.size());
        Assertions.assertSame((Object)b, (Object)queue.peek());
        Assertions.assertSame((Object)b, (Object)queue.poll());
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
    }

    @Test
    public void testClear() {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 0);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement a = new TestElement(5);
        TestElement b = new TestElement(10);
        TestElement c = new TestElement(2);
        TestElement d = new TestElement(6);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, a);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, c);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, d);
        queue.clear();
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, a);
        Assertions.assertSame((Object)a, (Object)queue.peek());
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        Assertions.assertSame((Object)a, (Object)queue.peek());
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, c);
        Assertions.assertSame((Object)c, (Object)queue.peek());
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, d);
        Assertions.assertSame((Object)c, (Object)queue.peek());
    }

    @Test
    public void testClearIgnoringIndexes() {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 0);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement a = new TestElement(5);
        TestElement b = new TestElement(10);
        TestElement c = new TestElement(2);
        TestElement d = new TestElement(6);
        TestElement e = new TestElement(11);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, a);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, c);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, d);
        queue.clearIgnoringIndexes();
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        try {
            queue.offer((Object)a);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, e);
        Assertions.assertSame((Object)e, (Object)queue.peek());
    }

    @Test
    public void testRemoval() {
        DefaultPriorityQueueTest.testRemoval(false);
    }

    @Test
    public void testRemovalTyped() {
        DefaultPriorityQueueTest.testRemoval(true);
    }

    @Test
    public void testRemovalFuzz() {
        int i;
        int numElements = ThreadLocalRandom.current().nextInt(0, 30);
        TestElement[] values = new TestElement[numElements];
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, values.length);
        for (i = 0; i < values.length; ++i) {
            do {
                values[i] = new TestElement(ThreadLocalRandom.current().nextInt(0, numElements * 2));
            } while (!queue.add((Object)values[i]));
        }
        for (i = 0; i < values.length; ++i) {
            try {
                Assertions.assertTrue((boolean)queue.removeTyped((Object)values[i]));
                Assertions.assertEquals((int)queue.size(), (int)(values.length - (i + 1)));
                continue;
            }
            catch (Throwable cause) {
                StringBuilder sb = new StringBuilder(values.length * 2);
                sb.append("error on removal of index: ").append(i).append(" [");
                for (TestElement value : values) {
                    sb.append(value).append(" ");
                }
                sb.append("]");
                throw new AssertionError(sb.toString(), cause);
            }
        }
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
    }

    private static void testRemoval(boolean typed) {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 4);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement a = new TestElement(5);
        TestElement b = new TestElement(10);
        TestElement c = new TestElement(2);
        TestElement d = new TestElement(6);
        TestElement notInQueue = new TestElement(-1);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, a);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, c);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, d);
        Assertions.assertFalse((boolean)(typed ? queue.removeTyped((Object)notInQueue) : queue.remove((Object)notInQueue)));
        Assertions.assertSame((Object)c, (Object)queue.peek());
        Assertions.assertEquals((int)4, (int)queue.size());
        Assertions.assertTrue((boolean)(typed ? queue.removeTyped((Object)b) : queue.remove((Object)b)));
        Assertions.assertSame((Object)c, (Object)queue.peek());
        Assertions.assertEquals((int)3, (int)queue.size());
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        Assertions.assertSame((Object)c, (Object)queue.peek());
        Assertions.assertEquals((int)4, (int)queue.size());
        Assertions.assertTrue((boolean)(typed ? queue.removeTyped((Object)d) : queue.remove((Object)d)));
        Assertions.assertSame((Object)c, (Object)queue.peek());
        Assertions.assertEquals((int)3, (int)queue.size());
        Assertions.assertTrue((boolean)(typed ? queue.removeTyped((Object)b) : queue.remove((Object)b)));
        Assertions.assertSame((Object)c, (Object)queue.peek());
        Assertions.assertEquals((int)2, (int)queue.size());
        Assertions.assertTrue((boolean)(typed ? queue.removeTyped((Object)c) : queue.remove((Object)c)));
        Assertions.assertSame((Object)a, (Object)queue.peek());
        Assertions.assertEquals((int)1, (int)queue.size());
        Assertions.assertTrue((boolean)(typed ? queue.removeTyped((Object)a) : queue.remove((Object)a)));
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
    }

    @Test
    public void testZeroInitialSize() {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 0);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement e = new TestElement(1);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, e);
        Assertions.assertSame((Object)e, (Object)queue.peek());
        Assertions.assertEquals((int)1, (int)queue.size());
        Assertions.assertFalse((boolean)queue.isEmpty());
        Assertions.assertSame((Object)e, (Object)queue.poll());
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
    }

    @Test
    public void testPriorityChange() {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 0);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement a = new TestElement(10);
        TestElement b = new TestElement(20);
        TestElement c = new TestElement(30);
        TestElement d = new TestElement(25);
        TestElement e = new TestElement(23);
        TestElement f = new TestElement(15);
        queue.add((Object)a);
        queue.add((Object)b);
        queue.add((Object)c);
        queue.add((Object)d);
        queue.add((Object)e);
        queue.add((Object)f);
        e.value = 35;
        queue.priorityChanged((Object)e);
        a.value = 40;
        queue.priorityChanged((Object)a);
        a.value = 31;
        queue.priorityChanged((Object)a);
        d.value = 10;
        queue.priorityChanged((Object)d);
        f.value = 5;
        queue.priorityChanged((Object)f);
        ArrayList<TestElement> expectedOrderList = new ArrayList<TestElement>(queue.size());
        expectedOrderList.addAll(Arrays.asList(a, b, c, d, e, f));
        Collections.sort(expectedOrderList, TestElementComparator.INSTANCE);
        Assertions.assertEquals((int)expectedOrderList.size(), (int)queue.size());
        Assertions.assertEquals((Object)expectedOrderList.isEmpty(), (Object)queue.isEmpty());
        Iterator itr = expectedOrderList.iterator();
        while (itr.hasNext()) {
            TestElement next = (TestElement)itr.next();
            TestElement poll = (TestElement)queue.poll();
            Assertions.assertEquals((Object)next, (Object)poll);
            itr.remove();
            Assertions.assertEquals((int)expectedOrderList.size(), (int)queue.size());
            Assertions.assertEquals((Object)expectedOrderList.isEmpty(), (Object)queue.isEmpty());
        }
    }

    private static void assertOffer(PriorityQueue<TestElement> queue, TestElement a) {
        Assertions.assertTrue((boolean)queue.offer((Object)a));
        Assertions.assertTrue((boolean)queue.contains((Object)a));
        Assertions.assertTrue((boolean)queue.containsTyped((Object)a));
        try {
            queue.offer((Object)a);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void assertEmptyQueue(PriorityQueue<TestElement> queue) {
        Assertions.assertNull((Object)queue.peek());
        Assertions.assertNull((Object)queue.poll());
        Assertions.assertEquals((int)0, (int)queue.size());
        Assertions.assertTrue((boolean)queue.isEmpty());
    }

    private static final class TestElement
    implements PriorityQueueNode {
        int value;
        private int priorityQueueIndex = -1;

        TestElement(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            return o instanceof TestElement && ((TestElement)o).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public int priorityQueueIndex(DefaultPriorityQueue queue) {
            return this.priorityQueueIndex;
        }

        public void priorityQueueIndex(DefaultPriorityQueue queue, int i) {
            this.priorityQueueIndex = i;
        }
    }

    private static final class TestElementComparator
    implements Comparator<TestElement>,
    Serializable {
        private static final long serialVersionUID = 7930368853384760103L;
        static final TestElementComparator INSTANCE = new TestElementComparator();

        private TestElementComparator() {
        }

        @Override
        public int compare(TestElement o1, TestElement o2) {
            return o1.value - o2.value;
        }
    }
}

