/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.internal;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.MathUtil;

public class MathUtilTest {
    @Test
    public void testFindNextPositivePowerOfTwo() {
        Assertions.assertEquals((int)1, (int)MathUtil.findNextPositivePowerOfTwo((int)0));
        Assertions.assertEquals((int)1, (int)MathUtil.findNextPositivePowerOfTwo((int)1));
        Assertions.assertEquals((int)1024, (int)MathUtil.findNextPositivePowerOfTwo((int)1000));
        Assertions.assertEquals((int)1024, (int)MathUtil.findNextPositivePowerOfTwo((int)1023));
        Assertions.assertEquals((int)2048, (int)MathUtil.findNextPositivePowerOfTwo((int)2048));
        Assertions.assertEquals((int)0x40000000, (int)MathUtil.findNextPositivePowerOfTwo((int)0x3FFFFFFF));
        Assertions.assertEquals((int)1, (int)MathUtil.findNextPositivePowerOfTwo((int)-1));
        Assertions.assertEquals((int)1, (int)MathUtil.findNextPositivePowerOfTwo((int)-10000));
    }

    @Test
    public void testSafeFindNextPositivePowerOfTwo() {
        Assertions.assertEquals((int)1, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)0));
        Assertions.assertEquals((int)1, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)1));
        Assertions.assertEquals((int)1024, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)1000));
        Assertions.assertEquals((int)1024, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)1023));
        Assertions.assertEquals((int)2048, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)2048));
        Assertions.assertEquals((int)0x40000000, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)0x3FFFFFFF));
        Assertions.assertEquals((int)1, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)-1));
        Assertions.assertEquals((int)1, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)-10000));
        Assertions.assertEquals((int)0x40000000, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)0x40000000, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)0x40000001));
        Assertions.assertEquals((int)1, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)1, (int)MathUtil.safeFindNextPositivePowerOfTwo((int)-2147483647));
    }

    @Test
    public void testIsOutOfBounds() {
        Assertions.assertFalse((boolean)MathUtil.isOutOfBounds((int)0, (int)0, (int)0));
        Assertions.assertFalse((boolean)MathUtil.isOutOfBounds((int)0, (int)0, (int)1));
        Assertions.assertFalse((boolean)MathUtil.isOutOfBounds((int)0, (int)1, (int)1));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)1, (int)1, (int)1));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)Integer.MAX_VALUE, (int)1, (int)1));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)1));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        Assertions.assertFalse((boolean)MathUtil.isOutOfBounds((int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        Assertions.assertFalse((boolean)MathUtil.isOutOfBounds((int)0, (int)0x7FFFFFFE, (int)Integer.MAX_VALUE));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)0, (int)Integer.MAX_VALUE, (int)0x7FFFFFFE));
        Assertions.assertFalse((boolean)MathUtil.isOutOfBounds((int)0x7FFFFFFE, (int)1, (int)Integer.MAX_VALUE));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)0x7FFFFFFE, (int)1, (int)0x7FFFFFFE));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)0x7FFFFFFE, (int)2, (int)Integer.MAX_VALUE));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)1, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)0, (int)1, (int)Integer.MIN_VALUE));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)0, (int)1, (int)-1));
        Assertions.assertTrue((boolean)MathUtil.isOutOfBounds((int)0, (int)Integer.MAX_VALUE, (int)0));
    }

    @Test
    public void testCompare() {
        Assertions.assertEquals((int)-1, (int)MathUtil.compare((int)0, (int)1));
        Assertions.assertEquals((int)-1, (int)MathUtil.compare((long)0L, (long)1L));
        Assertions.assertEquals((int)-1, (int)MathUtil.compare((int)0, (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)-1, (int)MathUtil.compare((long)0L, (long)Long.MAX_VALUE));
        Assertions.assertEquals((int)0, (int)MathUtil.compare((int)0, (int)0));
        Assertions.assertEquals((int)0, (int)MathUtil.compare((long)0L, (long)0L));
        Assertions.assertEquals((int)0, (int)MathUtil.compare((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)0, (int)MathUtil.compare((long)Long.MIN_VALUE, (long)Long.MIN_VALUE));
        Assertions.assertEquals((int)1, (int)MathUtil.compare((int)Integer.MAX_VALUE, (int)0));
        Assertions.assertEquals((int)1, (int)MathUtil.compare((int)Integer.MAX_VALUE, (int)0x7FFFFFFE));
        Assertions.assertEquals((int)1, (int)MathUtil.compare((long)Long.MAX_VALUE, (long)0L));
        Assertions.assertEquals((int)1, (int)MathUtil.compare((long)Long.MAX_VALUE, (long)0x7FFFFFFFFFFFFFFEL));
    }
}

