/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.ImmediateEventExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.ImmediateExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ThreadExecutorMap;

public class ThreadExecutorMapTest {
    @Test
    public void testDecorateExecutor() {
        Executor executor = ThreadExecutorMap.apply((Executor)ImmediateExecutor.INSTANCE, (EventExecutor)ImmediateEventExecutor.INSTANCE);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                Assertions.assertSame((Object)ImmediateEventExecutor.INSTANCE, (Object)ThreadExecutorMap.currentExecutor());
            }
        });
    }

    @Test
    public void testDecorateRunnable() {
        ThreadExecutorMap.apply((Runnable)new Runnable(){

            @Override
            public void run() {
                Assertions.assertSame((Object)ImmediateEventExecutor.INSTANCE, (Object)ThreadExecutorMap.currentExecutor());
            }
        }, (EventExecutor)ImmediateEventExecutor.INSTANCE).run();
    }

    @Test
    public void testDecorateThreadFactory() throws InterruptedException {
        ThreadFactory threadFactory = ThreadExecutorMap.apply((ThreadFactory)Executors.defaultThreadFactory(), (EventExecutor)ImmediateEventExecutor.INSTANCE);
        Thread thread = threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                Assertions.assertSame((Object)ImmediateEventExecutor.INSTANCE, (Object)ThreadExecutorMap.currentExecutor());
            }
        });
        thread.start();
        thread.join();
    }
}

