/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.internal;

import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.TypeParameterMatcher;

public class TypeParameterMatcherTest {
    @Test
    public void testConcreteClass() throws Exception {
        TypeParameterMatcher m = TypeParameterMatcher.find(new TypeQ(), TypeX.class, (String)"A");
        Assertions.assertFalse((boolean)m.match(new Object()));
        Assertions.assertFalse((boolean)m.match((Object)new A()));
        Assertions.assertFalse((boolean)m.match((Object)new AA()));
        Assertions.assertTrue((boolean)m.match((Object)new AAA()));
        Assertions.assertFalse((boolean)m.match((Object)new B()));
        Assertions.assertFalse((boolean)m.match((Object)new BB()));
        Assertions.assertFalse((boolean)m.match((Object)new BBB()));
        Assertions.assertFalse((boolean)m.match((Object)new C()));
        Assertions.assertFalse((boolean)m.match((Object)new CC()));
    }

    @Test
    public void testUnsolvedParameter() throws Exception {
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                TypeParameterMatcher.find(new TypeQ(), TypeX.class, (String)"B");
            }
        });
    }

    @Test
    public void testAnonymousClass() throws Exception {
        TypeParameterMatcher m = TypeParameterMatcher.find((Object)new TypeQ<BBB>(){}, TypeX.class, (String)"B");
        Assertions.assertFalse((boolean)m.match(new Object()));
        Assertions.assertFalse((boolean)m.match((Object)new A()));
        Assertions.assertFalse((boolean)m.match((Object)new AA()));
        Assertions.assertFalse((boolean)m.match((Object)new AAA()));
        Assertions.assertFalse((boolean)m.match((Object)new B()));
        Assertions.assertFalse((boolean)m.match((Object)new BB()));
        Assertions.assertTrue((boolean)m.match((Object)new BBB()));
        Assertions.assertFalse((boolean)m.match((Object)new C()));
        Assertions.assertFalse((boolean)m.match((Object)new CC()));
    }

    @Test
    public void testAbstractClass() throws Exception {
        TypeParameterMatcher m = TypeParameterMatcher.find(new TypeQ(), TypeX.class, (String)"C");
        Assertions.assertFalse((boolean)m.match(new Object()));
        Assertions.assertFalse((boolean)m.match((Object)new A()));
        Assertions.assertFalse((boolean)m.match((Object)new AA()));
        Assertions.assertFalse((boolean)m.match((Object)new AAA()));
        Assertions.assertFalse((boolean)m.match((Object)new B()));
        Assertions.assertFalse((boolean)m.match((Object)new BB()));
        Assertions.assertFalse((boolean)m.match((Object)new BBB()));
        Assertions.assertFalse((boolean)m.match((Object)new C()));
        Assertions.assertTrue((boolean)m.match((Object)new CC()));
    }

    @Test
    public void testInaccessibleClass() throws Exception {
        TypeParameterMatcher m = TypeParameterMatcher.find((Object)new U<T>(){}, U.class, (String)"E");
        Assertions.assertFalse((boolean)m.match(new Object()));
        Assertions.assertTrue((boolean)m.match((Object)new T()));
    }

    @Test
    public void testArrayAsTypeParam() throws Exception {
        TypeParameterMatcher m = TypeParameterMatcher.find((Object)new U<byte[]>(){}, U.class, (String)"E");
        Assertions.assertFalse((boolean)m.match(new Object()));
        Assertions.assertTrue((boolean)m.match((Object)new byte[1]));
    }

    @Test
    public void testRawType() throws Exception {
        TypeParameterMatcher m = TypeParameterMatcher.find((Object)new U(){}, U.class, (String)"E");
        Assertions.assertTrue((boolean)m.match(new Object()));
    }

    @Test
    public void testInnerClass() throws Exception {
        TypeParameterMatcher m = TypeParameterMatcher.find(new V<E>().u, U.class, (String)"E");
        Assertions.assertTrue((boolean)m.match(new Object()));
    }

    @Test
    public void testErasure() throws Exception {
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                TypeParameterMatcher m = TypeParameterMatcher.find(new X(), W.class, (String)"E");
                Assertions.assertTrue((boolean)m.match((Object)new Date()));
                Assertions.assertFalse((boolean)m.match(new Object()));
            }
        });
    }

    private static class X<T, E>
    extends W<E> {
        T t;

        private X() {
        }
    }

    private static abstract class W<E> {
        E e;

        private W() {
        }
    }

    private static class V<E> {
        U<E> u = new U<E>(){};

        private V() {
        }
    }

    private static class U<E> {
        E a;

        private U() {
        }
    }

    private static class T {
        private T() {
        }
    }

    public static class CC
    extends C {
    }

    public static class C {
    }

    public static class BBB
    extends BB {
    }

    public static class BB
    extends B {
    }

    public static class B {
    }

    public static class AAA
    extends AA {
    }

    public static class AA
    extends A {
    }

    public static class A {
    }

    public static class TypeQ<I extends BBB>
    extends TypeZ<AAA, I> {
    }

    public static abstract class TypeZ<G extends AA, H extends BB>
    extends TypeY<CC, G, H> {
    }

    public static class TypeY<D extends C, E extends A, F extends B>
    extends TypeX<E, F, D> {
    }

    public static class TypeX<A, B, C> {
        A a;
        B b;
        C c;
    }
}

