/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.neo4j.cypher.internal.compiler.v2_0.prettifier.Prettifier$;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.JavaTestDocsGenerator;
import org.neo4j.test.TestData;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public abstract class AbstractJavaDocTestBase
implements GraphHolder {
    @Rule
    public TestData<JavaTestDocsGenerator> gen = TestData.producedThrough((TestData.Producer)JavaTestDocsGenerator.PRODUCER);
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this, (boolean)true));
    protected ExecutionEngine engine;
    protected static GraphDatabaseService db;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void shutdownDb() {
        try {
            if (db != null) {
                db.shutdown();
            }
        }
        finally {
            db = null;
        }
    }

    public GraphDatabaseService graphdb() {
        return db;
    }

    protected String createCypherSnippet(String cypherQuery) {
        String snippet = Prettifier$.MODULE$.apply(cypherQuery);
        return AsciidocHelper.createAsciiDocSnippet((String)"cypher", (String)snippet);
    }

    @Before
    public void setUp() {
        GraphDatabaseService graphdb = this.graphdb();
        GraphDatabaseServiceCleaner.cleanDatabaseContent((GraphDatabaseService)graphdb);
        ((JavaTestDocsGenerator)this.gen.get()).setGraph(graphdb);
        this.engine = new ExecutionEngine(graphdb);
    }

    @After
    public void doc() {
        ((JavaTestDocsGenerator)this.gen.get()).document("target/docs/dev", "examples");
    }
}

