/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.sql.SQLException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.examples.CypherSql;
import org.neo4j.examples.ImpermanentGraphJavaDocTestBase;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.test.JavaTestDocsGenerator;
import org.neo4j.test.TestData;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public class CypherSqlDocIT
extends ImpermanentGraphJavaDocTestBase {
    private static CypherSql cyperSql;

    @BeforeClass
    public static void setUpDbs() throws SQLException {
        cyperSql = new CypherSql(new TestGraphDatabaseFactory().newImpermanentDatabase());
        cyperSql.createDbs();
    }

    @AfterClass
    public static void tearDownDbs() throws SQLException {
        cyperSql.shutdown();
    }

    @Test
    @Documented(value=" This guide is for people who understand SQL. You can use that prior\n knowledge to quickly get going with Cypher and start exploring Neo4j.\n\n [[query-sql-start]]\n == Finding basic patterns ==\n\n SQL starts with the result you want -- we `SELECT` what we want and then\n declare how to source it. In Cypher, instead you find nodes\n and relationships that are connected in a certain way by describing\n them as a graph pattern in a `MATCH` clause. The query may then execute from\n any found instances of the pattern.\n\n From a SQL point of view, the identifiers in a pattern are like table names\n that point to a set of nodes or relationships. The set can be listed\n literally, come via parameters, or as I show in the following example, be\n defined by an index look-up.\n\n So in fact rather than being `SELECT`-like, the `MATCH` clause is\n somewhere between the `FROM` and the `WHERE` clause in SQL.\n\n .SQL Query\n @@Start-sql-query\n\n @@Start-sql-result\n\n .Cypher Query\n @@Start-cypher-query\n\n @@Start-cypher-result\n\n Cypher allows multiple starting points. This should not be strange from a SQL perspective --\n every table in the `FROM` clause is another starting point.\n\n [[query-sql-match]]\n == Matching connected nodes ==\n\n Unlike SQL which operates on sets, Cypher predominantly works on sub-graphs.\n The relational equivalent is the current set of tuples being evaluated during a `SELECT` query.\n\n The shape of the sub-graph is specified in the `MATCH` clause.\n The `MATCH` clause is analogous to the `JOIN` in SQL. A normal a->b relationship is an\n inner join between nodes a and b -- both sides have to have at least one match, or nothing is returned.\n\n We'll start with a simple example, where we find all email addresses that are connected to\n the person ``Anakin''. This is an ordinary one-to-many relationship.\n\n .SQL Query\n @@Match-sql-query\n\n @@Match-sql-result\n\n .Cypher Query\n @@Match-cypher-query\n\n @@Match-cypher-result\n\n There is no join table here, but if one is necessary the next example will show how to do that, writing the pattern relationship like so:\n `-[r:belongs_to]->` will introduce (the equivalent of) join table available as the variable `r`.\n In reality this is a named relationship in Cypher, so we're saying ``join `Person` to `Group` via `belongs_to`.''\n To illustrate this, consider this image, comparing the SQL model and Neo4j/Cypher.\n\n ifdef::nonhtmloutput[]\n image::RDBMSvsGraph.svg[scaledwidth=\"100%\"]\n endif::nonhtmloutput[]\n ifndef::nonhtmloutput[]\n image::RDBMSvsGraph.svg.png[]\n endif::nonhtmloutput[]\n\n And here are example queries:\n\n .SQL Query\n @@JoinEntity-sql-query\n\n @@JoinEntity-sql-result\n\n .Cypher Query\n @@JoinEntity-cypher-query\n\n @@JoinEntity-cypher-result\n\n An http://www.codinghorror.com/blog/2007/10/a-visual-explanation-of-sql-joins.html[outer join] is just as easy.\n Add +OPTIONAL+ before the match and it's an optional relationship between nodes -- the outer join of Cypher.\n\n Whether it's a left outer join, or a right outer join is defined by which side of the pattern has a starting point.\n This example is a left outer join, because the bound node is on the left side:\n\n .SQL Query\n @@LeftJoin-sql-query\n\n @@LeftJoin-sql-result\n\n .Cypher Query\n @@LeftJoin-cypher-query\n\n @@LeftJoin-cypher-result\n\n Relationships in Neo4j are first class citizens -- it's like the SQL tables are pre-joined with each other.\n So, naturally, Cypher is designed to be able to handle highly connected data easily.\n\n One such domain is tree structures -- anyone that has tried storing tree structures in SQL knows\n that you have to work hard to get around the limitations of the relational model.\n There are even books on the subject.\n\n To find all the groups and sub-groups that Bridget belongs to, this query is enough in Cypher:\n\n .Cypher Query\n @@RecursiveJoin-cypher-query\n\n @@RecursiveJoin-cypher-result\n\n The `*` after the relationship type means that there can be multiple hops across +belongs_to+ relationships between group and user.\n Some SQL dialects have recursive abilities, that allow the expression of queries like this, but you may have a hard time wrapping your head around those.\n Expressing something like this in SQL is hugely impractical if not practically impossible.\n\n [[query-sql-where]]\n == Where ==\n\n This is the easiest thing to understand -- it's the same animal in both languages.\n It filters out result sets/subgraphs.\n Not all predicates have an equivalent in the other language, but the concept is the same.\n\n .SQL Query\n @@Where-sql-query\n\n @@Where-sql-result\n\n .Cypher Query\n @@Where-cypher-query\n\n @@Where-cypher-result\n\n [[query-sql-return]]\n == Return ==\n This is SQL's `SELECT`.\n We just put it in the end because it felt better to have it there --\n you do a lot of matching and filtering, and finally, you return something.\n\n Aggregate queries work just like they do in SQL, apart from the fact that there is no explicit `GROUP BY` clause.\n Everything in the return clause that is not an aggregate function will be used as the grouping columns.\n\n .SQL Query\n @@Return-sql-query\n\n @@Return-sql-result\n\n .Cypher Query\n @@Return-cypher-query\n\n @@Return-cypher-result\n\n Order by is the same in both languages -- `ORDER BY` expression `ASC`/`DESC`.\n Nothing weird here.\n\n // == Recursive queries ==\n\n\n\n")
    @TestData.Title(value="From SQL to Cypher")
    public void test() throws Exception {
        for (CypherSql.TestData query : CypherSqlDocIT.cyperSql.queries) {
            String rawSqlResult = null;
            if (query.sql != null) {
                String sqlSnippet = AsciidocHelper.createSqlSnippet((String)query.sql);
                ((JavaTestDocsGenerator)this.gen.get()).addSnippet(query.name + "-sql-query", sqlSnippet);
                rawSqlResult = cyperSql.executeSql(query.sql);
                String sqlResult = AsciidocHelper.createQueryResultSnippet((String)rawSqlResult);
                ((JavaTestDocsGenerator)this.gen.get()).addSnippet(query.name + "-sql-result", sqlResult);
            }
            String cypherSnippet = this.createCypherSnippet(query.cypher);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet(query.name + "-cypher-query", cypherSnippet);
            String rawCypherResult = cyperSql.executeCypher(query.cypher);
            String cypherResult = AsciidocHelper.createQueryResultSnippet((String)rawCypherResult);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet(query.name + "-cypher-result", cypherResult);
            for (String match : query.matchStrings) {
                if (query.sql != null) {
                    Assert.assertTrue((String)("SQL result doesn't contain: '" + match + "'"), (boolean)rawSqlResult.contains(match));
                }
                Assert.assertTrue((String)("Cypher result doesn't contain: '" + match + "'"), (boolean)rawCypherResult.contains(match));
            }
        }
    }
}

