/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.examples.AbstractJavaDocTestBase;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.UniqueFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.TargetDirectory;

public class GetOrCreateDocIT
extends AbstractJavaDocTestBase {
    @BeforeClass
    public static void init() {
        db = new GraphDatabaseFactory().newEmbeddedDatabase(TargetDirectory.forTest(GetOrCreateDocIT.class).makeGraphDbDir().getAbsolutePath());
    }

    private static String getUsername(int j) {
        return String.format("User%d", j);
    }

    @Test
    public void testPessimisticLocking() {
        new ThreadRunner<Node>((GetOrCreate)new PessimisticGetOrCreate()){

            @Override
            Node createDependency() {
                return GetOrCreateDocIT.createLockNode(GetOrCreateDocIT.this.graphdb());
            }
        }.run();
    }

    @Test
    public void getOrCreateWithUniqueFactory() throws Exception {
        new ThreadRunner<UniqueFactory<Node>>((GetOrCreate)new UniqueFactoryGetOrCreate()){

            @Override
            UniqueFactory<Node> createDependency() {
                return GetOrCreateDocIT.this.createUniqueFactory(GetOrCreateDocIT.this.graphdb());
            }
        }.run();
    }

    @Test
    public void getOrCreateUsingCypher() throws Exception {
        new ThreadRunner<ExecutionEngine>((GetOrCreate)new CypherGetOrCreate()){

            @Override
            ExecutionEngine createDependency() {
                return GetOrCreateDocIT.this.createExecutionEngineAndConstraint(GetOrCreateDocIT.this.graphdb());
            }
        }.run();
    }

    public Node getOrCreateUserPessimistically(String username, GraphDatabaseService graphDb, Node lockNode) {
        try (Transaction tx = graphDb.beginTx();){
            Index usersIndex = graphDb.index().forNodes("users");
            Node userNode = (Node)usersIndex.get("name", (Object)username).getSingle();
            if (userNode != null) {
                Node node = userNode;
                return node;
            }
            tx.acquireWriteLock((PropertyContainer)lockNode);
            userNode = (Node)usersIndex.get("name", (Object)username).getSingle();
            if (userNode == null) {
                userNode = graphDb.createNode(new Label[]{DynamicLabel.label((String)"User")});
                usersIndex.add((PropertyContainer)userNode, "name", (Object)username);
                userNode.setProperty("name", (Object)username);
            }
            tx.success();
            Node node = userNode;
            return node;
        }
    }

    public static Node createLockNode(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            Node lockNode = graphDb.createNode();
            tx.success();
            Node node = lockNode;
            return node;
        }
    }

    private UniqueFactory<Node> createUniqueFactory(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            UniqueFactory.UniqueNodeFactory result = new UniqueFactory.UniqueNodeFactory(graphDb, "users"){

                protected void initialize(Node created, Map<String, Object> properties) {
                    created.addLabel(DynamicLabel.label((String)"User"));
                    created.setProperty("name", properties.get("name"));
                }
            };
            tx.success();
            UniqueFactory.UniqueNodeFactory uniqueNodeFactory = result;
            return uniqueNodeFactory;
        }
    }

    public Node getOrCreateUserWithUniqueFactory(String username, GraphDatabaseService graphDb, UniqueFactory<Node> factory) {
        try (Transaction tx = graphDb.beginTx();){
            Node node = (Node)factory.getOrCreate("name", (Object)username);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    /*
     * Loose catch block
     */
    private Node getOrCreateWithCypher(String username, GraphDatabaseService graphDb, ExecutionEngine engine) {
        Node result = null;
        ResourceIterator resultIterator = null;
        Transaction tx = graphDb.beginTx();
        Throwable throwable = null;
        String queryString = "MERGE (n:User {name: {name}}) RETURN n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", username);
        resultIterator = engine.execute(queryString, parameters).columnAs("n");
        result = (Node)resultIterator.next();
        tx.success();
        Node node = result;
        if (resultIterator != null && resultIterator.hasNext()) {
            Node other = (Node)resultIterator.next();
            throw new IllegalStateException("Merge returned more than one node: " + result + " and " + other);
        }
        return node;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            {
                catch (Throwable throwable3) {
                    if (resultIterator != null && resultIterator.hasNext()) {
                        Node other2 = (Node)resultIterator.next();
                        throw new IllegalStateException("Merge returned more than one node: " + result + " and " + other2);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private ExecutionEngine createExecutionEngineAndConstraint(GraphDatabaseService graphdb) {
        try (Transaction tx = graphdb.beginTx();){
            graphdb.schema().constraintFor(DynamicLabel.label((String)"User")).assertPropertyIsUnique("name").create();
            tx.success();
        }
        return new ExecutionEngine(this.graphdb());
    }

    private static void assertUserExistsUniquelyInIndex(GraphDatabaseService graph, Transaction tx, String username) {
        Assert.assertNotNull((String)String.format("User '%s' not created.", username), (Object)graph.index().forNodes("users").get("name", (Object)username).getSingle());
        tx.success();
    }

    private static void assertUserExistsUniquelyInGraphDb(GraphDatabaseService graph, Transaction tx, String username) {
        Label label = DynamicLabel.label((String)"User");
        Node result = (Node)IteratorUtil.singleOrNull((Iterable)graph.findNodesByLabelAndProperty(label, "name", (Object)username));
        Assert.assertNotNull((String)String.format("User '%s' not created.", username), (Object)result);
        tx.success();
    }

    private static class GetOrCreateTask<D>
    extends Thread {
        private final GraphDatabaseService db;
        private final int numUsers;
        private final GetOrCreate<D> impl;
        private final D dependency;
        volatile List<Node> result;
        volatile RuntimeException failure;

        GetOrCreateTask(GraphDatabaseService db, int numUsers, GetOrCreate<D> impl, String name, D dependency) {
            super(name);
            this.db = db;
            this.numUsers = numUsers;
            this.impl = impl;
            this.dependency = dependency;
        }

        @Override
        public void run() {
            try {
                ArrayList<Node> subresult = new ArrayList<Node>();
                for (int j = 0; j < this.numUsers; ++j) {
                    subresult.add(this.impl.getOrCreateUser(GetOrCreateDocIT.getUsername(j), this.db, this.dependency));
                }
                this.result = subresult;
            }
            catch (RuntimeException e) {
                this.failure = e;
            }
        }
    }

    abstract class ThreadRunner<D>
    implements Runnable {
        static final int NUM_USERS = 100;
        final GetOrCreate<D> impl;

        ThreadRunner(GetOrCreate<D> impl) {
            this.impl = impl;
        }

        abstract D createDependency();

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void var7_14;
            D dependency = this.createDependency();
            ArrayList<GetOrCreateTask<D>> threads = new ArrayList<GetOrCreateTask<D>>();
            int numThreads = Runtime.getRuntime().availableProcessors() * 2;
            for (int i = 0; i < numThreads; ++i) {
                String string = String.format("%s thread %d", GetOrCreateDocIT.class.getSimpleName(), i);
                threads.add(new GetOrCreateTask<D>(AbstractJavaDocTestBase.db, 100, this.impl, string, dependency));
            }
            for (Thread thread : threads) {
                thread.start();
            }
            RuntimeException failure = null;
            ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
            for (GetOrCreateTask getOrCreateTask : threads) {
                try {
                    getOrCreateTask.join();
                    if (failure == null) {
                        failure = getOrCreateTask.failure;
                    }
                    arrayList.add(getOrCreateTask.result);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (failure != null) {
                throw failure;
            }
            Assert.assertEquals((long)numThreads, (long)arrayList.size());
            List firstResult = (List)arrayList.remove(0);
            for (List list : arrayList) {
                Assert.assertEquals((Object)firstResult, (Object)list);
            }
            boolean bl = false;
            while (var7_14 < 100) {
                String string = GetOrCreateDocIT.getUsername((int)var7_14);
                GraphDatabaseService graphdb = GetOrCreateDocIT.this.graphdb();
                this.impl.getOrCreateUser(string, graphdb, dependency);
                try (Transaction tx = graphdb.beginTx();){
                    this.impl.assertUserExistsUniquely(graphdb, tx, string);
                }
                catch (NoSuchElementException e) {
                    throw new RuntimeException(String.format("User '%s' not created uniquely.", string), e);
                }
                ++var7_14;
            }
        }
    }

    class CypherGetOrCreate
    extends GetOrCreate<ExecutionEngine> {
        CypherGetOrCreate() {
        }

        @Override
        public Node getOrCreateUser(String username, GraphDatabaseService graphDb, ExecutionEngine engine) {
            return GetOrCreateDocIT.this.getOrCreateWithCypher(username, graphDb, engine);
        }
    }

    class UniqueFactoryGetOrCreate
    extends GetOrCreate<UniqueFactory<Node>> {
        UniqueFactoryGetOrCreate() {
        }

        @Override
        public Node getOrCreateUser(String username, GraphDatabaseService graphDb, UniqueFactory<Node> uniqueFactory) {
            return GetOrCreateDocIT.this.getOrCreateUserWithUniqueFactory(username, graphDb, uniqueFactory);
        }

        @Override
        void assertUserExistsUniquely(GraphDatabaseService graphDb, Transaction tx, String username) {
            super.assertUserExistsUniquely(graphDb, tx, username);
            GetOrCreateDocIT.assertUserExistsUniquelyInIndex(graphDb, tx, username);
        }
    }

    class PessimisticGetOrCreate
    extends GetOrCreate<Node> {
        PessimisticGetOrCreate() {
        }

        @Override
        public Node getOrCreateUser(String username, GraphDatabaseService graphDb, Node lockNode) {
            return GetOrCreateDocIT.this.getOrCreateUserPessimistically(username, graphDb, lockNode);
        }
    }

    abstract class GetOrCreate<D> {
        GetOrCreate() {
        }

        abstract Node getOrCreateUser(String var1, GraphDatabaseService var2, D var3);

        void assertUserExistsUniquely(GraphDatabaseService graphDb, Transaction tx, String username) {
            GetOrCreateDocIT.assertUserExistsUniquelyInGraphDb(graphDb, tx, username);
        }
    }
}

