/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.test.TestGraphDatabaseFactory;

public class Neo4jBasicDocTest {
    protected GraphDatabaseService graphDb;

    @Before
    public void prepareTestDatabase() {
        this.graphDb = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @After
    public void destroyTestDatabase() {
        this.graphDb.shutdown();
    }

    @Test
    public void startWithConfiguration() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.nodestore_mapped_memory_size, "10M").setConfig(GraphDatabaseSettings.string_block_size, "60").setConfig(GraphDatabaseSettings.array_block_size, "300").newGraphDatabase();
        db.shutdown();
    }

    @Test
    public void shouldCreateNode() {
        Node n = null;
        try (Transaction tx = this.graphDb.beginTx();){
            n = this.graphDb.createNode();
            n.setProperty("name", (Object)"Nancy");
            tx.success();
        }
        Assert.assertThat((Object)n.getId(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-1L))));
        tx = this.graphDb.beginTx();
        var3_3 = null;
        try {
            Node foundNode = this.graphDb.getNodeById(n.getId());
            Assert.assertThat((Object)foundNode.getId(), (Matcher)Matchers.is((Object)n.getId()));
            Assert.assertThat((Object)((String)foundNode.getProperty("name")), (Matcher)Matchers.is((Object)"Nancy"));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

