/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import java.util.Iterator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.test.TargetDirectory;

public class PathFindingDocTest {
    private static GraphDatabaseService graphDb;
    private Transaction tx;

    @BeforeClass
    public static void startDb() {
        String storeDir = TargetDirectory.forTest(PathFindingDocTest.class).makeGraphDbDir().getAbsolutePath();
        PathFindingDocTest.deleteFileOrDirectory(new File(storeDir));
        graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(storeDir);
    }

    @Before
    public void doBefore() {
        this.tx = graphDb.beginTx();
    }

    @After
    public void doAfter() {
        this.tx.success();
        this.tx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void shutdownDb() {
        try {
            if (graphDb != null) {
                graphDb.shutdown();
            }
        }
        finally {
            graphDb = null;
        }
    }

    @Test
    public void shortestPathExample() {
        Node startNode = graphDb.createNode();
        Node middleNode1 = graphDb.createNode();
        Node middleNode2 = graphDb.createNode();
        Node middleNode3 = graphDb.createNode();
        Node endNode = graphDb.createNode();
        this.createRelationshipsBetween(startNode, middleNode1, endNode);
        this.createRelationshipsBetween(startNode, middleNode2, middleNode3, endNode);
        PathFinder finder = GraphAlgoFactory.shortestPath((PathExpander)PathExpanders.forTypeAndDirection((RelationshipType)ExampleTypes.MY_TYPE, (Direction)Direction.OUTGOING), (int)15);
        Iterable paths = finder.findAllPaths(startNode, endNode);
        Path path = (Path)paths.iterator().next();
        Assert.assertEquals((long)2L, (long)path.length());
        Assert.assertEquals((Object)startNode, (Object)path.startNode());
        Assert.assertEquals((Object)endNode, (Object)path.endNode());
        Iterator iterator = path.nodes().iterator();
        iterator.next();
        Assert.assertEquals((Object)middleNode1, iterator.next());
    }

    private void createRelationshipsBetween(Node ... nodes) {
        for (int i = 0; i < nodes.length - 1; ++i) {
            nodes[i].createRelationshipTo(nodes[i + 1], (RelationshipType)ExampleTypes.MY_TYPE);
        }
    }

    @Test
    public void dijkstraUsage() {
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)ExampleTypes.MY_TYPE);
        rel.setProperty("cost", (Object)1.0);
        this.findCheapestPathWithDijkstra(node1, node2);
    }

    public WeightedPath findCheapestPathWithDijkstra(Node nodeA, Node nodeB) {
        PathFinder finder = GraphAlgoFactory.dijkstra((PathExpander)PathExpanders.forTypeAndDirection((RelationshipType)ExampleTypes.MY_TYPE, (Direction)Direction.BOTH), (String)"cost");
        WeightedPath path = (WeightedPath)finder.findSinglePath(nodeA, nodeB);
        path.weight();
        return path;
    }

    private Node createNode(Object ... properties) {
        return this.setProperties(graphDb.createNode(), properties);
    }

    private <T extends PropertyContainer> T setProperties(T entity, Object[] properties) {
        for (int i = 0; i < properties.length; ++i) {
            String key = properties[i++].toString();
            Object value = properties[i];
            entity.setProperty(key, value);
        }
        return entity;
    }

    private Relationship createRelationship(Node start, Node end, Object ... properties) {
        return this.setProperties(start.createRelationshipTo(end, (RelationshipType)ExampleTypes.MY_TYPE), properties);
    }

    @Test
    public void astarExample() {
        Node nodeA = this.createNode("name", "A", "x", 0.0, "y", 0.0);
        Node nodeB = this.createNode("name", "B", "x", 7.0, "y", 0.0);
        Node nodeC = this.createNode("name", "C", "x", 2.0, "y", 1.0);
        Relationship relAB = this.createRelationship(nodeA, nodeC, "length", 2.0);
        Relationship relBC = this.createRelationship(nodeC, nodeB, "length", 3.0);
        Relationship relAC = this.createRelationship(nodeA, nodeB, "length", 10.0);
        EstimateEvaluator<Double> estimateEvaluator = new EstimateEvaluator<Double>(){

            public Double getCost(Node node, Node goal) {
                double dx = (Double)node.getProperty("x") - (Double)goal.getProperty("x");
                double dy = (Double)node.getProperty("y") - (Double)goal.getProperty("y");
                double result = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                return result;
            }
        };
        PathFinder astar = GraphAlgoFactory.aStar((PathExpander)PathExpanders.allTypesAndDirections(), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)"length"), (EstimateEvaluator)estimateEvaluator);
        WeightedPath path = (WeightedPath)astar.findSinglePath(nodeA, nodeB);
    }

    public static void deleteFileOrDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                PathFindingDocTest.deleteFileOrDirectory(child);
            }
        } else {
            file.delete();
        }
    }

    private static enum ExampleTypes implements RelationshipType
    {
        MY_TYPE;

    }
}

