/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.util.FileUtils;

public class ReadOnlyDocTest {
    protected GraphDatabaseService graphDb;

    @Before
    public void prepareReadOnlyDatabase() throws IOException {
        File dir = new File("target/read-only-db/location");
        if (dir.exists()) {
            FileUtils.deleteRecursively((File)dir);
        }
        new GraphDatabaseFactory().newEmbeddedDatabase("target/read-only-db/location").shutdown();
        this.graphDb = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder("target/read-only-db/location").setConfig(GraphDatabaseSettings.read_only, "true").newGraphDatabase();
    }

    @After
    public void shutdownDatabase() {
        this.graphDb.shutdown();
    }

    @Test
    public void makeSureDbIsOnlyReadable() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.graphDb.createNode();
            Assert.fail((String)"expected exception");
        }
        catch (ReadOnlyDbException readOnlyDbException) {
            // empty catch block
        }
    }
}

