/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples.orderedpath;

import java.io.File;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.examples.orderedpath.OrderedPath;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.JavaDocsGenerator;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public class OrderedPathDocTest {
    private static OrderedPath orderedPath;
    private static JavaDocsGenerator gen;
    private static GraphDatabaseService db;

    @BeforeClass
    public static void setUp() throws IOException {
        File dir = new File("target/neo4j-orderedpath-db");
        if (dir.exists()) {
            FileUtils.deleteRecursively((File)dir);
        }
        db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        orderedPath = new OrderedPath(db);
        gen = new JavaDocsGenerator("ordered-path-java", "dev");
    }

    @AfterClass
    public static void tearDown() {
        orderedPath.shutdownGraph();
    }

    @Test
    public void testPath() {
        Node A = orderedPath.createTheGraph();
        TraversalDescription traversalDescription = orderedPath.findPaths();
        try (Transaction tx = db.beginTx();){
            Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)traversalDescription.traverse(A)));
        }
        String output = orderedPath.printPaths(traversalDescription, A);
        Assert.assertTrue((boolean)output.contains("(A)--[REL1]-->(B)--[REL2]-->(C)--[REL3]-->(D)"));
        String graph = AsciidocHelper.createGraphVizDeletingReferenceNode((String)"Ordered Path Graph", (GraphDatabaseService)OrderedPathDocTest.orderedPath.db, (String)"java");
        Assert.assertFalse((boolean)graph.isEmpty());
        gen.saveToFile("graph", graph);
        gen.saveToFile("output", AsciidocHelper.createOutputSnippet((String)output));
    }
}

