/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.Paths;

public class CalculateShortestPath {
    private static final String DB_PATH = "target/neo4j-shortest-path";
    private static final String NAME_KEY = "name";
    private static RelationshipType KNOWS = DynamicRelationshipType.withName((String)"KNOWS");
    private static GraphDatabaseService graphDb;
    private static Index<Node> indexService;

    public static void main(String[] args) {
        CalculateShortestPath.deleteFileOrDirectory(new File(DB_PATH));
        graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
        CalculateShortestPath.registerShutdownHook();
        try (Transaction tx = graphDb.beginTx();){
            indexService = graphDb.index().forNodes("nodes");
            CalculateShortestPath.createChain("Neo", "Trinity");
            CalculateShortestPath.createChain("Neo", "Morpheus", "Trinity");
            CalculateShortestPath.createChain("Morpheus", "Cypher", "Agent Smith");
            CalculateShortestPath.createChain("Morpheus", "Agent Smith");
            tx.success();
        }
        tx = graphDb.beginTx();
        var2_2 = null;
        try {
            Node neo = CalculateShortestPath.getOrCreateNode("Neo");
            Node agentSmith = CalculateShortestPath.getOrCreateNode("Agent Smith");
            PathFinder finder = GraphAlgoFactory.shortestPath((PathExpander)PathExpanders.forTypeAndDirection((RelationshipType)KNOWS, (Direction)Direction.BOTH), (int)4);
            Path foundPath = finder.findSinglePath(neo, agentSmith);
            System.out.println("Path from Neo to Agent Smith: " + Paths.simplePathToString((Path)foundPath, (String)NAME_KEY));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var2_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        System.out.println("Shutting down database ...");
        graphDb.shutdown();
    }

    private static void createChain(String ... names) {
        for (int i = 0; i < names.length - 1; ++i) {
            Node firstNode = CalculateShortestPath.getOrCreateNode(names[i]);
            Node secondNode = CalculateShortestPath.getOrCreateNode(names[i + 1]);
            firstNode.createRelationshipTo(secondNode, KNOWS);
        }
    }

    private static Node getOrCreateNode(String name) {
        Node node = (Node)indexService.get(NAME_KEY, (Object)name).getSingle();
        if (node == null) {
            node = graphDb.createNode();
            node.setProperty(NAME_KEY, (Object)name);
            indexService.add((PropertyContainer)node, NAME_KEY, (Object)name);
        }
        return node;
    }

    private static void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                graphDb.shutdown();
            }
        });
    }

    private static void deleteFileOrDirectory(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    CalculateShortestPath.deleteFileOrDirectory(child);
                }
            }
            file.delete();
        }
    }
}

