/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.io.fs.FileUtils;

public class EmbeddedNeo4j {
    private static final String DB_PATH = "target/neo4j-hello-db";
    public String greeting;
    GraphDatabaseService graphDb;
    Node firstNode;
    Node secondNode;
    Relationship relationship;

    public static void main(String[] args) throws IOException {
        EmbeddedNeo4j hello = new EmbeddedNeo4j();
        hello.createDb();
        hello.removeData();
        hello.shutDown();
    }

    void createDb() throws IOException {
        FileUtils.deleteRecursively((File)new File(DB_PATH));
        this.graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
        EmbeddedNeo4j.registerShutdownHook(this.graphDb);
        try (Transaction tx = this.graphDb.beginTx();){
            this.firstNode = this.graphDb.createNode();
            this.firstNode.setProperty("message", (Object)"Hello, ");
            this.secondNode = this.graphDb.createNode();
            this.secondNode.setProperty("message", (Object)"World!");
            this.relationship = this.firstNode.createRelationshipTo(this.secondNode, (RelationshipType)RelTypes.KNOWS);
            this.relationship.setProperty("message", (Object)"brave Neo4j ");
            System.out.print(this.firstNode.getProperty("message"));
            System.out.print(this.relationship.getProperty("message"));
            System.out.print(this.secondNode.getProperty("message"));
            this.greeting = (String)this.firstNode.getProperty("message") + (String)this.relationship.getProperty("message") + (String)this.secondNode.getProperty("message");
            tx.success();
        }
    }

    void removeData() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.firstNode.getSingleRelationship((RelationshipType)RelTypes.KNOWS, Direction.OUTGOING).delete();
            this.firstNode.delete();
            this.secondNode.delete();
            tx.success();
        }
    }

    void shutDown() {
        System.out.println();
        System.out.println("Shutting down database ...");
        this.graphDb.shutdown();
    }

    private static void registerShutdownHook(final GraphDatabaseService graphDb) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                graphDb.shutdown();
            }
        });
    }

    private static enum RelTypes implements RelationshipType
    {
        KNOWS;

    }
}

