/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.Index;
import org.neo4j.io.fs.FileUtils;

public class EmbeddedNeo4jWithIndexing {
    private static final String DB_PATH = "target/neo4j-store";
    private static final String USERNAME_KEY = "username";
    private static GraphDatabaseService graphDb;
    private static Index<Node> nodeIndex;

    public static void main(String[] args) throws IOException {
        FileUtils.deleteRecursively((File)new File(DB_PATH));
        graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
        EmbeddedNeo4jWithIndexing.registerShutdownHook();
        try (Transaction tx = graphDb.beginTx();){
            nodeIndex = graphDb.index().forNodes("nodes");
            for (int id = 0; id < 100; ++id) {
                EmbeddedNeo4jWithIndexing.createAndIndexUser(EmbeddedNeo4jWithIndexing.idToUserName(id));
            }
            int idToFind = 45;
            String userName = EmbeddedNeo4jWithIndexing.idToUserName(idToFind);
            Node foundUser = (Node)nodeIndex.get(USERNAME_KEY, (Object)userName).getSingle();
            System.out.println("The username of user " + idToFind + " is " + foundUser.getProperty(USERNAME_KEY));
            for (Node user : nodeIndex.query(USERNAME_KEY, (Object)"*")) {
                nodeIndex.remove((PropertyContainer)user, USERNAME_KEY, user.getProperty(USERNAME_KEY));
                user.delete();
            }
            tx.success();
        }
        EmbeddedNeo4jWithIndexing.shutdown();
    }

    private static void shutdown() {
        graphDb.shutdown();
    }

    private static String idToUserName(int id) {
        return "user" + id + "@neo4j.org";
    }

    private static Node createAndIndexUser(String username) {
        Node node = graphDb.createNode();
        node.setProperty(USERNAME_KEY, (Object)username);
        nodeIndex.add((PropertyContainer)node, USERNAME_KEY, (Object)username);
        return node;
    }

    private static void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EmbeddedNeo4jWithIndexing.shutdown();
            }
        });
    }
}

