/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.io.fs.FileUtils;

public class EmbeddedNeo4jWithNewIndexing {
    private static final String DB_PATH = "target/neo4j-store-with-new-indexing";

    public static void main(String[] args) throws IOException {
        String nameToFind;
        int idToFind;
        Throwable throwable;
        ResourceIterator users;
        Object userNode;
        Label label;
        IndexDefinition indexDefinition;
        Schema schema;
        System.out.println("Starting database ...");
        FileUtils.deleteRecursively((File)new File(DB_PATH));
        GraphDatabaseService graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
        try (Object tx = graphDb.beginTx();){
            schema = graphDb.schema();
            indexDefinition = schema.indexFor(DynamicLabel.label((String)"User")).on("username").create();
            tx.success();
        }
        tx = graphDb.beginTx();
        var4_5 = null;
        try {
            schema = graphDb.schema();
            schema.awaitIndexOnline(indexDefinition, 10L, TimeUnit.SECONDS);
        }
        catch (Throwable x2) {
            var4_5 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var4_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Transaction tx = graphDb.beginTx();
        tx = null;
        try {
            label = DynamicLabel.label((String)"User");
            for (int id = 0; id < 100; ++id) {
                userNode = graphDb.createNode(new Label[]{label});
                userNode.setProperty("username", (Object)("user" + id + "@neo4j.org"));
            }
            System.out.println("Users created");
            tx.success();
        }
        catch (Throwable x2) {
            tx = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (tx != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        ((Throwable)tx).addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Label label2 = DynamicLabel.label((String)"User");
        int idToFind2 = 45;
        String nameToFind2 = "user" + idToFind2 + "@neo4j.org";
        Transaction tx2 = graphDb.beginTx();
        userNode = null;
        try {
            users = graphDb.findNodes(label2, "username", (Object)nameToFind2);
            throwable = null;
            try {
                ArrayList<Object> userNodes = new ArrayList<Object>();
                while (users.hasNext()) {
                    userNodes.add(users.next());
                }
                for (Node node : userNodes) {
                    System.out.println("The username of user " + idToFind2 + " is " + node.getProperty("username"));
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (users != null) {
                    if (throwable != null) {
                        try {
                            users.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        users.close();
                    }
                }
            }
        }
        catch (Throwable x2) {
            userNode = x2;
            throw x2;
        }
        finally {
            if (tx2 != null) {
                if (userNode != null) {
                    try {
                        tx2.close();
                    }
                    catch (Throwable x2) {
                        ((Throwable)userNode).addSuppressed(x2);
                    }
                } else {
                    tx2.close();
                }
            }
        }
        Label label3 = DynamicLabel.label((String)"User");
        int idToFind3 = 45;
        String nameToFind3 = "user" + idToFind3 + "@neo4j.org";
        Transaction tx3 = graphDb.beginTx();
        userNode = null;
        try {
            users = graphDb.findNodes(label3, "username", (Object)nameToFind3);
            throwable = null;
            try {
                if (users.hasNext()) {
                    Node x2 = (Node)users.next();
                }
                users.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (users != null) {
                    if (throwable != null) {
                        try {
                            users.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        users.close();
                    }
                }
            }
        }
        catch (Throwable x2) {
            userNode = x2;
            throw x2;
        }
        finally {
            if (tx3 != null) {
                if (userNode != null) {
                    try {
                        tx3.close();
                    }
                    catch (Throwable x2) {
                        ((Throwable)userNode).addSuppressed(x2);
                    }
                } else {
                    tx3.close();
                }
            }
        }
        tx = graphDb.beginTx();
        Throwable throwable3 = null;
        try {
            label = DynamicLabel.label((String)"User");
            idToFind = 45;
            nameToFind = "user" + idToFind + "@neo4j.org";
            for (Node node : IteratorUtil.loop((Iterator)graphDb.findNodes(label, "username", (Object)nameToFind))) {
                node.setProperty("username", (Object)("user" + (idToFind + 1) + "@neo4j.org"));
            }
            tx.success();
        }
        catch (Throwable x2) {
            throwable3 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (throwable3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        throwable3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = graphDb.beginTx();
        throwable3 = null;
        try {
            label = DynamicLabel.label((String)"User");
            idToFind = 46;
            nameToFind = "user" + idToFind + "@neo4j.org";
            for (Node node : IteratorUtil.loop((Iterator)graphDb.findNodes(label, "username", (Object)nameToFind))) {
                node.delete();
            }
            tx.success();
        }
        catch (Throwable x2) {
            throwable3 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (throwable3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        throwable3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = graphDb.beginTx();
        throwable3 = null;
        try {
            label = DynamicLabel.label((String)"User");
            for (IndexDefinition indexDefinition2 : graphDb.schema().getIndexes(label)) {
                indexDefinition2.drop();
            }
            tx.success();
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        throwable3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        System.out.println("Shutting down database ...");
        graphDb.shutdown();
    }
}

