/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.Index;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.ShellSettings;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;

public class Neo4jShell {
    private static final String DB_PATH = "neo4j-store";
    private static final String USERNAME_KEY = "username";
    private static GraphDatabaseService graphDb;

    public static void main(String[] args) throws Exception {
        Neo4jShell.registerShutdownHookForNeo();
        boolean trueForLocal = Neo4jShell.waitForUserInput("Would you like to start a local shell instance or enable neo4j to accept remote connections [l/r]? ").equalsIgnoreCase("l");
        if (trueForLocal) {
            Neo4jShell.startLocalShell();
        } else {
            Neo4jShell.startRemoteShellAndWait();
        }
        Neo4jShell.shutdown();
    }

    private static void startLocalShell() throws Exception {
        graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
        Neo4jShell.createExampleGraph();
        GraphDatabaseShellServer shellServer = new GraphDatabaseShellServer((GraphDatabaseAPI)graphDb);
        ShellLobby.newClient((ShellServer)shellServer).grabPrompt();
        shellServer.shutdown();
    }

    private static void startRemoteShellAndWait() throws Exception {
        graphDb = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(DB_PATH).setConfig(ShellSettings.remote_shell_enabled, "true").newGraphDatabase();
        Neo4jShell.createExampleGraph();
        Neo4jShell.waitForUserInput("Remote shell enabled, connect to it by executing\nthe shell-client script in a separate terminal.The script is located in the bin directory.\n\nWhen you're done playing around, just press [Enter] in this terminal ");
    }

    private static String waitForUserInput(String textToSystemOut) throws Exception {
        System.out.print(textToSystemOut);
        return new BufferedReader(new InputStreamReader(System.in, "UTF-8")).readLine();
    }

    private static void createExampleGraph() {
        try (Transaction tx = graphDb.beginTx();){
            System.out.println("Creating example graph ...");
            Random random = new Random();
            Node usersReferenceNode = graphDb.createNode();
            Index references = graphDb.index().forNodes("references");
            usersReferenceNode.setProperty("reference", (Object)"users");
            references.add((PropertyContainer)usersReferenceNode, "reference", (Object)"users");
            ArrayList<Node> users = new ArrayList<Node>();
            for (int id = 0; id < 100; ++id) {
                Node userNode = Neo4jShell.createUser(Neo4jShell.formUserName(id));
                usersReferenceNode.createRelationshipTo(userNode, (RelationshipType)RelTypes.USER);
                if (id > 10) {
                    int numberOfFriends = random.nextInt(5);
                    HashSet<Node> knows = new HashSet<Node>();
                    for (int i = 0; i < numberOfFriends; ++i) {
                        Node friend = (Node)users.get(random.nextInt(users.size()));
                        if (!knows.add(friend)) continue;
                        userNode.createRelationshipTo(friend, (RelationshipType)RelTypes.KNOWS);
                    }
                }
                users.add(userNode);
            }
            tx.success();
        }
    }

    private static void deleteExampleNodeSpace() {
        try (Transaction tx = graphDb.beginTx();){
            System.out.println("Deleting example graph ...");
            Node usersReferenceNode = (Node)graphDb.index().forNodes("references").get("reference", (Object)"users").getSingle();
            for (Relationship relationship : usersReferenceNode.getRelationships((RelationshipType)RelTypes.USER, Direction.OUTGOING)) {
                Node user = relationship.getEndNode();
                for (Relationship knowsRelationship : user.getRelationships(new RelationshipType[]{RelTypes.KNOWS})) {
                    knowsRelationship.delete();
                }
                user.delete();
                relationship.delete();
            }
            usersReferenceNode.getSingleRelationship((RelationshipType)RelTypes.USERS_REFERENCE, Direction.INCOMING).delete();
            usersReferenceNode.delete();
            tx.success();
        }
    }

    private static void shutdownGraphDb() {
        System.out.println("Shutting down database ...");
        graphDb.shutdown();
        graphDb = null;
    }

    private static void shutdown() {
        if (graphDb != null) {
            Neo4jShell.deleteExampleNodeSpace();
            Neo4jShell.shutdownGraphDb();
        }
    }

    private static void registerShutdownHookForNeo() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Neo4jShell.shutdown();
            }
        });
    }

    private static String formUserName(int id) {
        return "user" + id + "@neo4j.org";
    }

    private static Node createUser(String username) {
        Node node = graphDb.createNode();
        node.setProperty(USERNAME_KEY, (Object)username);
        return node;
    }

    private static enum RelTypes implements RelationshipType
    {
        USERS_REFERENCE,
        USER,
        KNOWS;

    }
}

