/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.io.fs.FileUtils;

public class TerminateTransactions {
    private static final String DB_PATH = "target/neo4j-terminate-tx-db";

    public static void main(String[] args) throws IOException {
        System.out.println(new TerminateTransactions().run());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run() throws IOException {
        FileUtils.deleteRecursively((File)new File(DB_PATH));
        GraphDatabaseService graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)"CHILD");
        LinkedList<Node> nodes = new LinkedList<Node>();
        int depth = 1;
        try {
            try {
                Transaction tx = graphDb.beginTx();
                Throwable throwable = null;
                try {
                    try {
                        Node rootNode = graphDb.createNode();
                        nodes.add(rootNode);
                        Terminator terminator = new Terminator(tx);
                        terminator.terminateAfter(1000L);
                        while (true) {
                            int nodesToExpand = nodes.size();
                            for (int i = 0; i < nodesToExpand; ++i) {
                                Node parent = (Node)nodes.remove();
                                Node left = graphDb.createNode();
                                Node right = graphDb.createNode();
                                parent.createRelationshipTo(left, (RelationshipType)relType);
                                parent.createRelationshipTo(right, (RelationshipType)relType);
                                nodes.add(left);
                                nodes.add(right);
                            }
                            ++depth;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            tx.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (TransactionTerminatedException ignored) {
                String string = String.format("Created tree up to depth %s in 1 sec", depth);
                return string;
            }
        }
        finally {
            graphDb.shutdown();
        }
    }

    public class Terminator {
        private final Transaction tx;

        Terminator(Transaction tx) {
            this.tx = tx;
        }

        public void terminateAfter(final long millis) {
            Executors.newSingleThreadExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    long startTime = System.currentTimeMillis();
                    do {
                        try {
                            Thread.sleep(millis);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (System.currentTimeMillis() - startTime < millis);
                    Terminator.this.tx.terminate();
                }
            });
        }
    }
}

