/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.io.fs.FileUtils;

public class TraversalExample {
    private GraphDatabaseService db;
    private TraversalDescription friendsTraversal;
    private static final String DB_PATH = "target/neo4j-traversal-example";

    public static void main(String[] args) throws IOException {
        FileUtils.deleteRecursively((File)new File(DB_PATH));
        GraphDatabaseService database = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
        TraversalExample example = new TraversalExample(database);
        Node joe = example.createData();
        example.run(joe);
    }

    public TraversalExample(GraphDatabaseService db) {
        this.db = db;
        this.friendsTraversal = db.traversalDescription().depthFirst().relationships((RelationshipType)Rels.KNOWS).uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL);
    }

    private Node createData() {
        String query = "CREATE (joe {name: 'Joe'}), (sara {name: 'Sara'}), (lisa {name: 'Lisa'}), (peter {name: 'PETER'}), (dirk {name: 'Dirk'}), (lars {name: 'Lars'}), (ed {name: 'Ed'}),(joe)-[:KNOWS]->(sara), (lisa)-[:LIKES]->(joe), (peter)-[:KNOWS]->(sara), (dirk)-[:KNOWS]->(peter), (lars)-[:KNOWS]->(drk), (ed)-[:KNOWS]->(lars), (lisa)-[:KNOWS]->(lars) RETURN joe";
        Result result = this.db.execute(query);
        Object joe = result.columnAs("joe").next();
        if (joe instanceof Node) {
            return (Node)joe;
        }
        throw new RuntimeException("Joe isn't a node!");
    }

    private void run(Node joe) {
        try (Transaction tx = this.db.beginTx();){
            System.out.println(this.knowsLikesTraverser(joe));
            System.out.println(this.traverseBaseTraverser(joe));
            System.out.println(this.depth3(joe));
            System.out.println(this.depth4(joe));
            System.out.println(this.nodes(joe));
            System.out.println(this.relationships(joe));
        }
    }

    public String knowsLikesTraverser(Node node) {
        String output = "";
        for (Path position : this.db.traversalDescription().depthFirst().relationships((RelationshipType)Rels.KNOWS).relationships((RelationshipType)Rels.LIKES, Direction.INCOMING).evaluator(Evaluators.toDepth((int)5)).traverse(node)) {
            output = output + position + "\n";
        }
        return output;
    }

    public String traverseBaseTraverser(Node node) {
        String output = "";
        for (Path path : this.friendsTraversal.traverse(node)) {
            output = output + path + "\n";
        }
        return output;
    }

    public String depth3(Node node) {
        String output = "";
        for (Path path : this.friendsTraversal.evaluator(Evaluators.toDepth((int)3)).traverse(node)) {
            output = output + path + "\n";
        }
        return output;
    }

    public String depth4(Node node) {
        String output = "";
        for (Path path : this.friendsTraversal.evaluator(Evaluators.fromDepth((int)2)).evaluator(Evaluators.toDepth((int)4)).traverse(node)) {
            output = output + path + "\n";
        }
        return output;
    }

    public String nodes(Node node) {
        String output = "";
        for (Node currentNode : this.friendsTraversal.traverse(node).nodes()) {
            output = output + currentNode.getProperty("name") + "\n";
        }
        return output;
    }

    public String relationships(Node node) {
        String output = "";
        for (Relationship relationship : this.friendsTraversal.traverse(node).relationships()) {
            output = output + relationship.getType().name() + "\n";
        }
        return output;
    }

    private static enum Rels implements RelationshipType
    {
        LIKES,
        KNOWS;

    }
}

