/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples.socnet;

import org.neo4j.examples.socnet.Person;
import org.neo4j.examples.socnet.RelTypes;
import org.neo4j.examples.socnet.StatusUpdate;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.IterableWrapper;

public class PersonRepository {
    private final GraphDatabaseService graphDb;
    private final Index<Node> index;
    private final Node personRefNode;

    public PersonRepository(GraphDatabaseService graphDb, Index<Node> index) {
        this.graphDb = graphDb;
        this.index = index;
        this.personRefNode = this.getPersonsRootNode(graphDb);
    }

    private Node getPersonsRootNode(GraphDatabaseService graphDb) {
        Index referenceIndex = graphDb.index().forNodes("reference");
        IndexHits result = referenceIndex.get("reference", (Object)"person");
        if (result.hasNext()) {
            return (Node)result.next();
        }
        Node refNode = this.graphDb.createNode();
        refNode.setProperty("reference", (Object)"persons");
        referenceIndex.add((PropertyContainer)refNode, "reference", (Object)"persons");
        return refNode;
    }

    public Person createPerson(String name) throws Exception {
        Node newPersonNode = this.graphDb.createNode();
        this.personRefNode.createRelationshipTo(newPersonNode, (RelationshipType)RelTypes.A_PERSON);
        Node alreadyExist = (Node)this.index.get("name", (Object)name).getSingle();
        if (alreadyExist != null) {
            throw new Exception("Person with this name already exists ");
        }
        newPersonNode.setProperty("name", (Object)name);
        this.index.add((PropertyContainer)newPersonNode, "name", (Object)name);
        return new Person(newPersonNode);
    }

    public Person getPersonByName(String name) {
        Node personNode = (Node)this.index.get("name", (Object)name).getSingle();
        if (personNode == null) {
            throw new IllegalArgumentException("Person[" + name + "] not found");
        }
        return new Person(personNode);
    }

    public void deletePerson(Person person) {
        Node personNode = person.getUnderlyingNode();
        this.index.remove((PropertyContainer)personNode, "name", (Object)person.getName());
        for (Person friend : person.getFriends()) {
            person.removeFriend(friend);
        }
        personNode.getSingleRelationship((RelationshipType)RelTypes.A_PERSON, Direction.INCOMING).delete();
        for (StatusUpdate status : person.getStatus()) {
            Node statusNode = status.getUnderlyingNode();
            for (Relationship r : statusNode.getRelationships()) {
                r.delete();
            }
            statusNode.delete();
        }
        personNode.delete();
    }

    public Iterable<Person> getAllPersons() {
        return new IterableWrapper<Person, Relationship>(this.personRefNode.getRelationships(new RelationshipType[]{RelTypes.A_PERSON})){

            protected Person underlyingObjectToObject(Relationship personRel) {
                return new Person(personRel.getEndNode());
            }
        };
    }
}

