/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples.socnet;

import java.util.Date;
import java.util.Iterator;
import org.neo4j.examples.socnet.Person;
import org.neo4j.examples.socnet.RelTypes;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.helpers.collection.IteratorUtil;

public class StatusUpdate {
    private final Node underlyingNode;
    static final String TEXT = "TEXT";
    static final String DATE = "DATE";

    public StatusUpdate(Node underlyingNode) {
        this.underlyingNode = underlyingNode;
    }

    public Node getUnderlyingNode() {
        return this.underlyingNode;
    }

    public Person getPerson() {
        return new Person(this.getPersonNode());
    }

    private Node getPersonNode() {
        TraversalDescription traversalDescription = this.underlyingNode.getGraphDatabase().traversalDescription().depthFirst().relationships((RelationshipType)RelTypes.NEXT, Direction.INCOMING).relationships((RelationshipType)RelTypes.STATUS, Direction.INCOMING).evaluator(Evaluators.includeWhereLastRelationshipTypeIs((RelationshipType)RelTypes.STATUS, (RelationshipType[])new RelationshipType[0]));
        Traverser traverser = traversalDescription.traverse(this.getUnderlyingNode());
        return ((Path)IteratorUtil.singleOrNull((Iterator)traverser.iterator())).endNode();
    }

    public String getStatusText() {
        return (String)this.underlyingNode.getProperty(TEXT);
    }

    public Date getDate() {
        Long l = (Long)this.underlyingNode.getProperty(DATE);
        return new Date(l);
    }
}

