/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.util.Date;
import javax.management.ObjectName;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.jmx.JmxUtils;
import org.neo4j.test.TestGraphDatabaseFactory;

public class JmxDocTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readJmxProperties() {
        GraphDatabaseService graphDbService = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            Date startTime = JmxDocTest.getStartTimeFromManagementBean(graphDbService);
            Date now = new Date();
            Assert.assertTrue((startTime.before(now) || startTime.equals(now) ? 1 : 0) != 0);
        }
        finally {
            graphDbService.shutdown();
        }
    }

    @Test
    public void properErrorOnNonStandardGraphDatabase() {
        GraphDatabaseService graphDbService = (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class);
        try {
            JmxDocTest.getStartTimeFromManagementBean(graphDbService);
            Assert.fail((String)"Expected error");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Can only resolve object names for embedded Neo4j database instances, eg. instances created by GraphDatabaseFactory or HighlyAvailableGraphDatabaseFactory.", (Object)e.getMessage());
        }
    }

    private static Date getStartTimeFromManagementBean(GraphDatabaseService graphDbService) {
        ObjectName objectName = JmxUtils.getObjectName((GraphDatabaseService)graphDbService, (String)"Kernel");
        Date date = (Date)JmxUtils.getAttribute((ObjectName)objectName, (String)"KernelStartTime");
        return date;
    }
}

