/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.examples.NewMatrix;
import org.neo4j.test.JavaDocsGenerator;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public class MatrixDocTest {
    private static JavaDocsGenerator gen;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        gen = new JavaDocsGenerator("matrix-traversal-java", "dev");
    }

    @Test
    public void newMatrix() throws Exception {
        NewMatrix newMatrix = new NewMatrix();
        newMatrix.setUp();
        String friends = newMatrix.printNeoFriends();
        String hackers = newMatrix.printMatrixHackers();
        newMatrix.shutdown();
        this.check(friends, hackers);
        gen.saveToFile("new-friends", AsciidocHelper.createOutputSnippet((String)friends));
        gen.saveToFile("new-hackers", AsciidocHelper.createOutputSnippet((String)hackers));
    }

    private void check(String friends, String hackers) {
        Assert.assertTrue((boolean)friends.contains("friends found: 4"));
        Assert.assertTrue((boolean)friends.contains("Trinity"));
        Assert.assertTrue((boolean)friends.contains("Morpheus"));
        Assert.assertTrue((boolean)friends.contains("Cypher"));
        Assert.assertTrue((boolean)friends.contains("Agent Smith"));
        Assert.assertTrue((boolean)hackers.contains("hackers found: 1"));
        Assert.assertTrue((boolean)hackers.contains("The Architect"));
    }
}

