/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.examples.ImpermanentGraphJavaDocTestBase;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.JavaTestDocsGenerator;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public class RolesDocTest
extends ImpermanentGraphJavaDocTestBase {
    private static final String NAME = "name";
    private static final String ROLES_DOC = "This is an example showing a hierarchy of\nroles.\nWhat's interesting is that a tree is not sufficient for storing this kind of structure,\nas elaborated below.\n \nimage::roles.png[]\n \nThis is an implementation of an example found in the article\nhttp://www.codeproject.com/Articles/22824/A-Model-to-Represent-Directed-Acyclic-Graphs-DAG-o[A Model to Represent Directed Acyclic Graphs (DAG) on SQL Databases]\nby http://www.codeproject.com/script/Articles/MemberArticles.aspx?amid=274518[Kemal Erdogan].\nThe article discusses how to store http://en.wikipedia.org/wiki/Directed_acyclic_graph[\ndirected acyclic graphs] (DAGs)\nin SQL based DBs. DAGs are almost trees, but with a twist: it may be possible to reach\nthe same node through different paths. Trees are restricted from this possibility, which\nmakes them much easier to handle. In our case it is ``Ali'' and ``Engin'',\nas they are both admins and users and thus reachable through these group nodes.\nReality often looks this way and can't be captured by tree structures.\n \nIn the article an SQL Stored Procedure solution is provided. The main idea,\nthat also have some support from scientists, is to pre-calculate all possible (transitive) paths.\nPros and cons of this approach:\n \n* decent performance on read\n* low performance on insert\n* wastes _lots_ of space\n* relies on stored procedures\n \nIn Neo4j storing the roles is trivial. In this case we use +PART_OF+ (green edges) relationships\nto model the group hierarchy and +MEMBER_OF+ (blue edges) to model membership in groups.\nWe also connect the top level groups to the reference node by +ROOT+ relationships.\nThis gives us a useful partitioning of the graph. Neo4j has no predefined relationship\ntypes, you are free to create any relationship types and give them the semantics you want.\n \nLets now have a look at how to retrieve information from the graph. The the queries are done using <<cypher-query-lang, Cypher>>,\nthe Java code is using the Neo4j Traversal API (see <<tutorial-traversal-java-api>>, which is part of <<advanced-usage>>).\n\n== Get the admins ==\n \nIn Cypher, we could get the admins like this:\n \n@@query-get-admins\n \nresulting in:\n \n@@o-query-get-admins\n\nAnd here's the code when using the Java Traversal API:\n\n@@get-admins\n \nresulting in the output\n \n@@o-get-admins\n \nThe result is collected from the traverser using this code:\n \n@@read-traverser\n \n== Get the group memberships of a user ==\n \nIn Cypher:\n \n@@query-get-user-memberships\n \n@@o-query-get-user-memberships\n \nUsing the Neo4j Java Traversal API, this query looks like:\n \n@@get-user-memberships\n \nresulting in:\n \n@@o-get-user-memberships\n\n== Get all groups ==\n \nIn Cypher:\n \n@@query-get-groups\n \n@@o-query-get-groups\n \nIn Java:\n \n@@get-groups\n \nresulting in:\n \n@@o-get-groups\n \n== Get all members of all groups ==\n \nNow, let's try to find all users in the system being part of any group.\n\nIn Cypher, this looks like:\n \n@@query-get-members\n \nand results in the following output:\n \n@@o-query-get-members\n \nin Java:\n \n@@get-members\n \n@@o-get-members\n \nAs seen above, querying even more complex scenarios can be done using comparatively short\nconstructs in Cypher or Java.";

    @Test
    @Documented(value="This is an example showing a hierarchy of\nroles.\nWhat's interesting is that a tree is not sufficient for storing this kind of structure,\nas elaborated below.\n \nimage::roles.png[]\n \nThis is an implementation of an example found in the article\nhttp://www.codeproject.com/Articles/22824/A-Model-to-Represent-Directed-Acyclic-Graphs-DAG-o[A Model to Represent Directed Acyclic Graphs (DAG) on SQL Databases]\nby http://www.codeproject.com/script/Articles/MemberArticles.aspx?amid=274518[Kemal Erdogan].\nThe article discusses how to store http://en.wikipedia.org/wiki/Directed_acyclic_graph[\ndirected acyclic graphs] (DAGs)\nin SQL based DBs. DAGs are almost trees, but with a twist: it may be possible to reach\nthe same node through different paths. Trees are restricted from this possibility, which\nmakes them much easier to handle. In our case it is ``Ali'' and ``Engin'',\nas they are both admins and users and thus reachable through these group nodes.\nReality often looks this way and can't be captured by tree structures.\n \nIn the article an SQL Stored Procedure solution is provided. The main idea,\nthat also have some support from scientists, is to pre-calculate all possible (transitive) paths.\nPros and cons of this approach:\n \n* decent performance on read\n* low performance on insert\n* wastes _lots_ of space\n* relies on stored procedures\n \nIn Neo4j storing the roles is trivial. In this case we use +PART_OF+ (green edges) relationships\nto model the group hierarchy and +MEMBER_OF+ (blue edges) to model membership in groups.\nWe also connect the top level groups to the reference node by +ROOT+ relationships.\nThis gives us a useful partitioning of the graph. Neo4j has no predefined relationship\ntypes, you are free to create any relationship types and give them the semantics you want.\n \nLets now have a look at how to retrieve information from the graph. The the queries are done using <<cypher-query-lang, Cypher>>,\nthe Java code is using the Neo4j Traversal API (see <<tutorial-traversal-java-api>>, which is part of <<advanced-usage>>).\n\n== Get the admins ==\n \nIn Cypher, we could get the admins like this:\n \n@@query-get-admins\n \nresulting in:\n \n@@o-query-get-admins\n\nAnd here's the code when using the Java Traversal API:\n\n@@get-admins\n \nresulting in the output\n \n@@o-get-admins\n \nThe result is collected from the traverser using this code:\n \n@@read-traverser\n \n== Get the group memberships of a user ==\n \nIn Cypher:\n \n@@query-get-user-memberships\n \n@@o-query-get-user-memberships\n \nUsing the Neo4j Java Traversal API, this query looks like:\n \n@@get-user-memberships\n \nresulting in:\n \n@@o-get-user-memberships\n\n== Get all groups ==\n \nIn Cypher:\n \n@@query-get-groups\n \n@@o-query-get-groups\n \nIn Java:\n \n@@get-groups\n \nresulting in:\n \n@@o-get-groups\n \n== Get all members of all groups ==\n \nNow, let's try to find all users in the system being part of any group.\n\nIn Cypher, this looks like:\n \n@@query-get-members\n \nand results in the following output:\n \n@@o-query-get-members\n \nin Java:\n \n@@get-members\n \n@@o-get-members\n \nAs seen above, querying even more complex scenarios can be done using comparatively short\nconstructs in Cypher or Java.")
    @GraphDescription.Graph(value={"Admins ROOT Reference_Node", "Users ROOT Reference_Node", "HelpDesk PART_OF Admins", "Managers PART_OF Users", "Technicians PART_OF Users", "ABCTechnicians PART_OF Technicians", "Ali MEMBER_OF Users", "Ali MEMBER_OF Admins", "Engin MEMBER_OF Users", "Engin MEMBER_OF HelpDesk", "Demet MEMBER_OF HelpDesk", "Burcu MEMBER_OF Users", "Can MEMBER_OF Users", "Gul MEMBER_OF Managers", "Fuat MEMBER_OF Managers", "Hakan MEMBER_OF Technicians", "Irmak MEMBER_OF Technicians", "Jale MEMBER_OF ABCTechnicians"})
    public void user_roles_in_graphs() {
        ((JavaTestDocsGenerator)this.gen.get()).addTestSourceSnippets(this.getClass(), new String[]{"get-admins", "get-user-memberships", "get-groups", "get-members", "read-traverser"});
        System.out.println("All admins:");
        Node admins = this.getNodeByName("Admins");
        TraversalDescription traversalDescription = db.traversalDescription().breadthFirst().evaluator(Evaluators.excludeStartPosition()).relationships((RelationshipType)RoleRels.PART_OF, Direction.INCOMING).relationships((RelationshipType)RoleRels.MEMBER_OF, Direction.INCOMING);
        Traverser traverser = traversalDescription.traverse(admins);
        try (Transaction ignore = this.graphdb().beginTx();){
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("o-get-admins", AsciidocHelper.createOutputSnippet((String)this.traverserToString(traverser)));
            String query = "match ({name: 'Admins'})<-[:PART_OF*0..]-(group)<-[:MEMBER_OF]-(user) return user.name, group.name";
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("query-get-admins", this.createCypherSnippet(query));
            String result = db.execute(query).resultAsString();
            Assert.assertTrue((boolean)result.contains("Engin"));
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("o-query-get-admins", AsciidocHelper.createQueryResultSnippet((String)result));
            Node jale = this.getNodeByName("Jale");
            traversalDescription = db.traversalDescription().depthFirst().evaluator(Evaluators.excludeStartPosition()).relationships((RelationshipType)RoleRels.MEMBER_OF, Direction.OUTGOING).relationships((RelationshipType)RoleRels.PART_OF, Direction.OUTGOING);
            traverser = traversalDescription.traverse(jale);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("o-get-user-memberships", AsciidocHelper.createOutputSnippet((String)this.traverserToString(traverser)));
            query = "match ({name: 'Jale'})-[:MEMBER_OF]->()-[:PART_OF*0..]->(group) return group.name";
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("query-get-user-memberships", this.createCypherSnippet(query));
            result = db.execute(query).resultAsString();
            Assert.assertTrue((boolean)result.contains("Users"));
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("o-query-get-user-memberships", AsciidocHelper.createQueryResultSnippet((String)result));
            Node referenceNode = this.getNodeByName("Reference_Node");
            traversalDescription = db.traversalDescription().breadthFirst().evaluator(Evaluators.excludeStartPosition()).relationships((RelationshipType)RoleRels.ROOT, Direction.INCOMING).relationships((RelationshipType)RoleRels.PART_OF, Direction.INCOMING);
            traverser = traversalDescription.traverse(referenceNode);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("o-get-groups", AsciidocHelper.createOutputSnippet((String)this.traverserToString(traverser)));
            query = "match ({name: 'Reference_Node'})<-[:ROOT]->()<-[:PART_OF*0..]-(group) return group.name";
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("query-get-groups", this.createCypherSnippet(query));
            result = db.execute(query).resultAsString();
            Assert.assertTrue((boolean)result.contains("Users"));
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("o-query-get-groups", AsciidocHelper.createQueryResultSnippet((String)result));
            traversalDescription = db.traversalDescription().breadthFirst().evaluator(Evaluators.includeWhereLastRelationshipTypeIs((RelationshipType)RoleRels.MEMBER_OF, (RelationshipType[])new RelationshipType[0]));
            traverser = traversalDescription.traverse(referenceNode);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("o-get-members", AsciidocHelper.createOutputSnippet((String)this.traverserToString(traverser)));
            query = "match ({name: 'Reference_Node'})<-[:ROOT]->(root), p=(root)<-[PART_OF*0..]-()<-[:MEMBER_OF]-(user) return user.name, min(length(p)) order by min(length(p)), user.name";
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("query-get-members", this.createCypherSnippet(query));
            result = db.execute(query).resultAsString();
            Assert.assertTrue((boolean)result.contains("Engin"));
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("o-query-get-members", AsciidocHelper.createQueryResultSnippet((String)result));
        }
    }

    private String traverserToString(Traverser traverser) {
        String output = "";
        for (Path path : traverser) {
            Node node = path.endNode();
            output = output + "Found: " + node.getProperty(NAME) + " at depth: " + (path.length() - 1) + "\n";
        }
        return output;
    }

    private Node getNodeByName(String string) {
        return (Node)((Map)this.data.get()).get(string);
    }

    public static enum RoleRels implements RelationshipType
    {
        ROOT,
        PART_OF,
        MEMBER_OF;

    }
}

