/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.test.TargetDirectory;

public class StartWithConfigurationDocTest {
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void loadFromFile() {
        String pathToConfig = "src/test/resources/";
        GraphDatabaseService graphDb = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).loadPropertiesFromFile(pathToConfig + "neo4j.properties").newGraphDatabase();
        Assert.assertNotNull((Object)graphDb);
        graphDb.shutdown();
    }

    @Test
    public void loadFromHashmap() {
        GraphDatabaseService graphDb = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(GraphDatabaseSettings.pagecache_memory, "512M").setConfig(GraphDatabaseSettings.string_block_size, "60").setConfig(GraphDatabaseSettings.array_block_size, "300").newGraphDatabase();
        Assert.assertNotNull((Object)graphDb);
        graphDb.shutdown();
    }
}

