/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.IOException;
import java.util.Map;
import org.junit.Test;
import org.neo4j.examples.ImpermanentGraphJavaDocTestBase;
import org.neo4j.examples.TraversalExample;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.JavaTestDocsGenerator;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public class TraversalDocTest
extends ImpermanentGraphJavaDocTestBase {
    private static final String TRAVERSAL_DOC = "A\nlink:javadocs/org/neo4j/graphdb/traversal/TraversalDescription.html[traversal description] is built using a\nfluent interface and such a description can then spawn\nlink:javadocs/org/neo4j/graphdb/traversal/Traverser.html[traversers].\n\n@@graph\n\nWith the definition of the +RelationshipTypes+ as\n\n@@sourceRels\n\nThe graph can be traversed with for example the following traverser, starting at the ``Joe'' node:\n\n@@knowslikestraverser\n\nThe traversal will output:\n\n@@knowslikesoutput\n\nSince link:javadocs/org/neo4j/graphdb/traversal/TraversalDescription.html[+TraversalDescription+]s\nare immutable it is also useful to create template descriptions which holds common\nsettings shared by different traversals. For example, let's start with this traverser:\n\n@@basetraverser\n\nThis traverser would yield the following output (we will keep starting from the ``Joe'' node):\n\n@@baseoutput\n\nNow let's create a new traverser from it, restricting depth to three:\n\n@@depth3\n\nThis will give us the following result:\n\n@@output3\n\nOr how about from depth two to four?\nThat's done like this:\n\n@@depth4\n\nThis traversal gives us:\n\n@@output4\n\nFor various useful evaluators, see the\nlink:javadocs/org/neo4j/graphdb/traversal/Evaluators.html[Evaluators] Java API\nor simply implement the\nlink:javadocs/org/neo4j/graphdb/traversal/Evaluator.html[Evaluator] interface yourself.\n\nIf you're not interested in the link:javadocs/org/neo4j/graphdb/Path.html[+Path+]s,\nbut the link:javadocs/org/neo4j/graphdb/Node.html[+Node+]s\nyou can transform the traverser into an iterable of link:javadocs/org/neo4j/graphdb/traversal/Traverser.html#nodes()[nodes]\nlike this:\n\n@@nodes\n\nIn this case we use it to retrieve the names:\n\n@@nodeoutput\n\nlink:javadocs/org/neo4j/graphdb/traversal/Traverser.html#relationships()[Relationships]\nare fine as well, here's how to get them:\n\n@@relationships\n\nHere the relationship types are written, and we get:\n\n@@relationshipoutput\n\nTIP: The source code for the traversers in this example is available at:\n@@github";

    @Test
    @Documented(value="A\nlink:javadocs/org/neo4j/graphdb/traversal/TraversalDescription.html[traversal description] is built using a\nfluent interface and such a description can then spawn\nlink:javadocs/org/neo4j/graphdb/traversal/Traverser.html[traversers].\n\n@@graph\n\nWith the definition of the +RelationshipTypes+ as\n\n@@sourceRels\n\nThe graph can be traversed with for example the following traverser, starting at the ``Joe'' node:\n\n@@knowslikestraverser\n\nThe traversal will output:\n\n@@knowslikesoutput\n\nSince link:javadocs/org/neo4j/graphdb/traversal/TraversalDescription.html[+TraversalDescription+]s\nare immutable it is also useful to create template descriptions which holds common\nsettings shared by different traversals. For example, let's start with this traverser:\n\n@@basetraverser\n\nThis traverser would yield the following output (we will keep starting from the ``Joe'' node):\n\n@@baseoutput\n\nNow let's create a new traverser from it, restricting depth to three:\n\n@@depth3\n\nThis will give us the following result:\n\n@@output3\n\nOr how about from depth two to four?\nThat's done like this:\n\n@@depth4\n\nThis traversal gives us:\n\n@@output4\n\nFor various useful evaluators, see the\nlink:javadocs/org/neo4j/graphdb/traversal/Evaluators.html[Evaluators] Java API\nor simply implement the\nlink:javadocs/org/neo4j/graphdb/traversal/Evaluator.html[Evaluator] interface yourself.\n\nIf you're not interested in the link:javadocs/org/neo4j/graphdb/Path.html[+Path+]s,\nbut the link:javadocs/org/neo4j/graphdb/Node.html[+Node+]s\nyou can transform the traverser into an iterable of link:javadocs/org/neo4j/graphdb/traversal/Traverser.html#nodes()[nodes]\nlike this:\n\n@@nodes\n\nIn this case we use it to retrieve the names:\n\n@@nodeoutput\n\nlink:javadocs/org/neo4j/graphdb/traversal/Traverser.html#relationships()[Relationships]\nare fine as well, here's how to get them:\n\n@@relationships\n\nHere the relationship types are written, and we get:\n\n@@relationshipoutput\n\nTIP: The source code for the traversers in this example is available at:\n@@github")
    @GraphDescription.Graph(value={"Joe KNOWS Sara", "Lisa LIKES Joe", "Peter KNOWS Sara", "Dirk KNOWS Peter", "Lars KNOWS Dirk", "Ed KNOWS Lars", "Lisa KNOWS Lars"})
    public void how_to_use_the_Traversal_framework() {
        Node joe = (Node)((Map)this.data.get()).get("Joe");
        TraversalExample example = new TraversalExample(db);
        ((JavaTestDocsGenerator)this.gen.get()).addSnippet("graph", AsciidocHelper.createGraphVizWithNodeId((String)"Traversal Example Graph", (GraphDatabaseService)this.graphdb(), (String)((JavaTestDocsGenerator)this.gen.get()).getTitle()));
        try (Transaction tx = db.beginTx();){
            String output = example.knowsLikesTraverser(joe);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("knowslikesoutput", AsciidocHelper.createOutputSnippet((String)output));
            output = example.traverseBaseTraverser(joe);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("baseoutput", AsciidocHelper.createOutputSnippet((String)output));
            output = example.depth3(joe);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("output3", AsciidocHelper.createOutputSnippet((String)output));
            output = example.depth4(joe);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("output4", AsciidocHelper.createOutputSnippet((String)output));
            output = example.nodes(joe);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("nodeoutput", AsciidocHelper.createOutputSnippet((String)output));
            output = example.relationships(joe);
            ((JavaTestDocsGenerator)this.gen.get()).addSnippet("relationshipoutput", AsciidocHelper.createOutputSnippet((String)output));
            ((JavaTestDocsGenerator)this.gen.get()).addSourceSnippets(example.getClass(), new String[]{"knowslikestraverser", "sourceRels", "basetraverser", "depth3", "depth4", "nodes", "relationships"});
            ((JavaTestDocsGenerator)this.gen.get()).addGithubSourceLink("github", example.getClass(), "community/embedded-examples");
        }
    }

    @Test
    public void runAll() throws IOException {
        TraversalExample.main(null);
    }
}

