/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.examples.ImpermanentGraphJavaDocTestBase;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.JavaTestDocsGenerator;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public class UniquenessOfPathsDocTest
extends ImpermanentGraphJavaDocTestBase {
    private static final String UNIQUENESS_OF_PATHS_DOC = "Uniqueness of Paths in traversals.\n \nThis example is demonstrating the use of node uniqueness.\nBelow an imaginary domain graph with Principals\nthat own pets that are descendant to other pets.\n \n@@graph\n \nIn order to return all descendants\nof +Pet0+ which have the relation +owns+ to +Principal1+ (+Pet1+ and +Pet3+),\nthe Uniqueness of the traversal needs to be set to\n+NODE_PATH+ rather than the default +NODE_GLOBAL+ so that nodes\ncan be traversed more that once, and paths that have\ndifferent nodes but can have some nodes in common (like the\nstart and end node) can be returned.\n \n@@traverser\n \nThis will return the following paths:\n \n@@output\n \nIn the default `path.toString()` implementation, `(1)--[knows,2]-->(4)` denotes\na node with ID=1 having a relationship with ID 2 or type `knows` to a node with ID-4.\n \nLet's create a new +TraversalDescription+ from the old one,\nhaving +NODE_GLOBAL+ uniqueness to see the difference.\n \nTIP: The +TraversalDescription+ object is immutable,\n     so we have to use the new instance returned\n     with the new uniqueness setting.\n \n@@traverseNodeGlobal\n \nNow only one path is returned:\n \n@@outNodeGlobal";

    @GraphDescription.Graph(value={"Pet0 descendant Pet1", "Pet0 descendant Pet2", "Pet0 descendant Pet3", "Principal1 owns Pet1", "Principal2 owns Pet2", "Principal1 owns Pet3"})
    @Test
    @Documented(value="Uniqueness of Paths in traversals.\n \nThis example is demonstrating the use of node uniqueness.\nBelow an imaginary domain graph with Principals\nthat own pets that are descendant to other pets.\n \n@@graph\n \nIn order to return all descendants\nof +Pet0+ which have the relation +owns+ to +Principal1+ (+Pet1+ and +Pet3+),\nthe Uniqueness of the traversal needs to be set to\n+NODE_PATH+ rather than the default +NODE_GLOBAL+ so that nodes\ncan be traversed more that once, and paths that have\ndifferent nodes but can have some nodes in common (like the\nstart and end node) can be returned.\n \n@@traverser\n \nThis will return the following paths:\n \n@@output\n \nIn the default `path.toString()` implementation, `(1)--[knows,2]-->(4)` denotes\na node with ID=1 having a relationship with ID 2 or type `knows` to a node with ID-4.\n \nLet's create a new +TraversalDescription+ from the old one,\nhaving +NODE_GLOBAL+ uniqueness to see the difference.\n \nTIP: The +TraversalDescription+ object is immutable,\n     so we have to use the new instance returned\n     with the new uniqueness setting.\n \n@@traverseNodeGlobal\n \nNow only one path is returned:\n \n@@outNodeGlobal")
    public void pathUniquenessExample() {
        Node start = (Node)((Map)this.data.get()).get("Pet0");
        ((JavaTestDocsGenerator)this.gen.get()).addSnippet("graph", AsciidocHelper.createGraphVizWithNodeId((String)"Descendants Example Graph", (GraphDatabaseService)this.graphdb(), (String)((JavaTestDocsGenerator)this.gen.get()).getTitle()));
        this.gen.get();
        ((JavaTestDocsGenerator)this.gen.get()).addTestSourceSnippets(this.getClass(), new String[]{"traverser", "traverseNodeGlobal"});
        final Node target = (Node)((Map)this.data.get()).get("Principal1");
        TraversalDescription td = db.traversalDescription().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).evaluator(new Evaluator(){

            public Evaluation evaluate(Path path) {
                boolean endNodeIsTarget;
                return Evaluation.of((boolean)endNodeIsTarget, (!(endNodeIsTarget = path.endNode().equals(target)) ? 1 : 0) != 0);
            }
        });
        Traverser results = td.traverse(start);
        String output = "";
        int count = 0;
        try (Transaction ignore = db.beginTx();){
            for (Path path : results) {
                ++count;
                output = output + path.toString() + "\n";
            }
        }
        ((JavaTestDocsGenerator)this.gen.get()).addSnippet("output", AsciidocHelper.createOutputSnippet((String)output));
        Assert.assertEquals((long)2L, (long)count);
        TraversalDescription nodeGlobalTd = td.uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL);
        results = nodeGlobalTd.traverse(start);
        String output2 = "";
        count = 0;
        try (Transaction tx = db.beginTx();){
            for (Path path : results) {
                ++count;
                output2 = output2 + path.toString() + "\n";
            }
        }
        ((JavaTestDocsGenerator)this.gen.get()).addSnippet("outNodeGlobal", AsciidocHelper.createOutputSnippet((String)output2));
        Assert.assertEquals((long)1L, (long)count);
    }
}

