/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;

public class EmbeddedNeo4jWithCustomLogging {
    private static final File DB_PATH = new File("target/neo4j-store");
    private static GraphDatabaseService graphDb;

    public static void main(String[] args) throws IOException {
        FileUtils.deleteRecursively((File)DB_PATH);
        Object output = new Object();
        MyCustomLogProvider logProvider = new MyCustomLogProvider(output);
        graphDb = new GraphDatabaseFactory().setUserLogProvider((LogProvider)logProvider).newEmbeddedDatabase(DB_PATH);
        EmbeddedNeo4jWithCustomLogging.shutdown();
    }

    private static void shutdown() {
        graphDb.shutdown();
    }

    private static class MyCustomLogProvider
    implements LogProvider {
        public MyCustomLogProvider(Object output) {
        }

        public Log getLog(Class loggingClass) {
            return NullLog.getInstance();
        }

        public Log getLog(String context) {
            return NullLog.getInstance();
        }
    }
}

