/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileUtils;

public class EmbeddedNeo4jWithNewIndexing {
    private static final File DB_PATH = new File("target/neo4j-store-with-new-indexing");

    public static void main(String[] args) throws IOException {
        String nameToFind;
        int idToFind;
        Throwable throwable;
        Object userNode;
        IndexDefinition indexDefinition;
        System.out.println("Starting database ...");
        FileUtils.deleteRecursively((File)DB_PATH);
        GraphDatabaseService graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
        try (Object tx = graphDb.beginTx();){
            Schema schema = graphDb.schema();
            indexDefinition = schema.indexFor(Label.label((String)"User")).on("username").create();
            tx.success();
        }
        tx = graphDb.beginTx();
        var4_5 = null;
        try {
            Schema schema2 = graphDb.schema();
            schema2.awaitIndexOnline(indexDefinition, 10L, TimeUnit.SECONDS);
        }
        catch (Throwable schema2) {
            var4_5 = schema2;
            throw schema2;
        }
        finally {
            if (tx != null) {
                if (var4_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable schema2) {
                        var4_5.addSuppressed(schema2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = graphDb.beginTx();
        var4_5 = null;
        try {
            Schema schema3 = graphDb.schema();
            System.out.println(String.format("Percent complete: %1.0f%%", Float.valueOf(schema3.getIndexPopulationProgress(indexDefinition).getCompletedPercentage())));
        }
        catch (Throwable schema3) {
            var4_5 = schema3;
            throw schema3;
        }
        finally {
            if (tx != null) {
                if (var4_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable schema3) {
                        var4_5.addSuppressed(schema3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Transaction tx = graphDb.beginTx();
        tx = null;
        try {
            Label label2 = Label.label((String)"User");
            for (int id = 0; id < 100; ++id) {
                userNode = graphDb.createNode(new Label[]{label2});
                userNode.setProperty("username", (Object)("user" + id + "@neo4j.org"));
            }
            System.out.println("Users created");
            tx.success();
        }
        catch (Throwable label2) {
            tx = label2;
            throw label2;
        }
        finally {
            if (tx != null) {
                if (tx != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable label2) {
                        ((Throwable)tx).addSuppressed(label2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Label label3 = Label.label((String)"User");
        int idToFind2 = 45;
        String nameToFind2 = "user" + idToFind2 + "@neo4j.org";
        Transaction tx2 = graphDb.beginTx();
        userNode = null;
        try {
            throwable = null;
            try (ResourceIterator users2 = graphDb.findNodes(label3, "username", (Object)nameToFind2);){
                ArrayList<Object> userNodes = new ArrayList<Object>();
                while (users2.hasNext()) {
                    userNodes.add(users2.next());
                }
                for (Node node : userNodes) {
                    System.out.println("The username of user " + idToFind2 + " is " + node.getProperty("username"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable users2) {
            userNode = users2;
            throw users2;
        }
        finally {
            if (tx2 != null) {
                if (userNode != null) {
                    try {
                        tx2.close();
                    }
                    catch (Throwable users2) {
                        ((Throwable)userNode).addSuppressed(users2);
                    }
                } else {
                    tx2.close();
                }
            }
        }
        Label label = Label.label((String)"User");
        int idToFind3 = 45;
        String nameToFind3 = "user" + idToFind3 + "@neo4j.org";
        Transaction tx3 = graphDb.beginTx();
        userNode = null;
        try {
            throwable = null;
            try (ResourceIterator users = graphDb.findNodes(label, "username", (Object)nameToFind3);){
                if (users.hasNext()) {
                    Node node = (Node)users.next();
                }
                users.close();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (Throwable throwable6) {
            userNode = throwable6;
            throw throwable6;
        }
        finally {
            if (tx3 != null) {
                if (userNode != null) {
                    try {
                        tx3.close();
                    }
                    catch (Throwable throwable7) {
                        ((Throwable)userNode).addSuppressed(throwable7);
                    }
                } else {
                    tx3.close();
                }
            }
        }
        tx = graphDb.beginTx();
        Throwable throwable8 = null;
        try {
            Label label4 = Label.label((String)"User");
            idToFind = 45;
            nameToFind = "user" + idToFind + "@neo4j.org";
            for (Node node : Iterators.loop((Iterator)graphDb.findNodes(label4, "username", (Object)nameToFind))) {
                node.setProperty("username", (Object)("user" + (idToFind + 1) + "@neo4j.org"));
            }
            tx.success();
        }
        catch (Throwable label4) {
            throwable8 = label4;
            throw label4;
        }
        finally {
            if (tx != null) {
                if (throwable8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable label4) {
                        throwable8.addSuppressed(label4);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = graphDb.beginTx();
        throwable8 = null;
        try {
            Label label5 = Label.label((String)"User");
            idToFind = 46;
            nameToFind = "user" + idToFind + "@neo4j.org";
            for (Node node : Iterators.loop((Iterator)graphDb.findNodes(label5, "username", (Object)nameToFind))) {
                node.delete();
            }
            tx.success();
        }
        catch (Throwable label5) {
            throwable8 = label5;
            throw label5;
        }
        finally {
            if (tx != null) {
                if (throwable8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable label5) {
                        throwable8.addSuppressed(label5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = graphDb.beginTx();
        throwable8 = null;
        try {
            Label label2 = Label.label((String)"User");
            for (IndexDefinition indexDefinition2 : graphDb.schema().getIndexes(label2)) {
                indexDefinition2.drop();
            }
            tx.success();
        }
        catch (Throwable throwable9) {
            throwable8 = throwable9;
            throw throwable9;
        }
        finally {
            if (tx != null) {
                if (throwable8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable10) {
                        throwable8.addSuppressed(throwable10);
                    }
                } else {
                    tx.close();
                }
            }
        }
        System.out.println("Shutting down database ...");
        graphDb.shutdown();
    }
}

