/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.io.fs.FileUtils;

public class NewMatrix {
    private static final File MATRIX_DB = new File("target/matrix-new-db");
    private GraphDatabaseService graphDb;
    private long matrixNodeId;

    public static void main(String[] args) throws IOException {
        NewMatrix matrix = new NewMatrix();
        matrix.setUp();
        System.out.println(matrix.printNeoFriends());
        System.out.println(matrix.printMatrixHackers());
        matrix.shutdown();
    }

    public void setUp() throws IOException {
        FileUtils.deleteRecursively((File)MATRIX_DB);
        this.graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(MATRIX_DB);
        this.registerShutdownHook();
        this.createNodespace();
    }

    public void shutdown() {
        this.graphDb.shutdown();
    }

    public void createNodespace() {
        try (Transaction tx = this.graphDb.beginTx();){
            Node matrix = this.graphDb.createNode();
            this.matrixNodeId = matrix.getId();
            Node thomas = this.graphDb.createNode();
            thomas.setProperty("name", (Object)"Thomas Anderson");
            thomas.setProperty("age", (Object)29);
            matrix.createRelationshipTo(thomas, (RelationshipType)RelTypes.NEO_NODE);
            Node trinity = this.graphDb.createNode();
            trinity.setProperty("name", (Object)"Trinity");
            Relationship rel = thomas.createRelationshipTo(trinity, (RelationshipType)RelTypes.KNOWS);
            rel.setProperty("age", (Object)"3 days");
            Node morpheus = this.graphDb.createNode();
            morpheus.setProperty("name", (Object)"Morpheus");
            morpheus.setProperty("rank", (Object)"Captain");
            morpheus.setProperty("occupation", (Object)"Total badass");
            thomas.createRelationshipTo(morpheus, (RelationshipType)RelTypes.KNOWS);
            rel = morpheus.createRelationshipTo(trinity, (RelationshipType)RelTypes.KNOWS);
            rel.setProperty("age", (Object)"12 years");
            Node cypher = this.graphDb.createNode();
            cypher.setProperty("name", (Object)"Cypher");
            cypher.setProperty("last name", (Object)"Reagan");
            trinity.createRelationshipTo(cypher, (RelationshipType)RelTypes.KNOWS);
            rel = morpheus.createRelationshipTo(cypher, (RelationshipType)RelTypes.KNOWS);
            rel.setProperty("disclosure", (Object)"public");
            Node smith = this.graphDb.createNode();
            smith.setProperty("name", (Object)"Agent Smith");
            smith.setProperty("version", (Object)"1.0b");
            smith.setProperty("language", (Object)"C++");
            rel = cypher.createRelationshipTo(smith, (RelationshipType)RelTypes.KNOWS);
            rel.setProperty("disclosure", (Object)"secret");
            rel.setProperty("age", (Object)"6 months");
            Node architect = this.graphDb.createNode();
            architect.setProperty("name", (Object)"The Architect");
            smith.createRelationshipTo(architect, (RelationshipType)RelTypes.CODED_BY);
            tx.success();
        }
    }

    private Node getNeoNode() {
        return this.graphDb.getNodeById(this.matrixNodeId).getSingleRelationship((RelationshipType)RelTypes.NEO_NODE, Direction.OUTGOING).getEndNode();
    }

    public String printNeoFriends() {
        try (Transaction tx = this.graphDb.beginTx();){
            Node neoNode = this.getNeoNode();
            int numberOfFriends = 0;
            String output = neoNode.getProperty("name") + "'s friends:\n";
            Traverser friendsTraverser = this.getFriends(neoNode);
            for (Path friendPath : friendsTraverser) {
                output = output + "At depth " + friendPath.length() + " => " + friendPath.endNode().getProperty("name") + "\n";
                ++numberOfFriends;
            }
            output = output + "Number of friends found: " + numberOfFriends + "\n";
            Object object = output;
            return object;
        }
    }

    private Traverser getFriends(Node person) {
        TraversalDescription td = this.graphDb.traversalDescription().breadthFirst().relationships((RelationshipType)RelTypes.KNOWS, Direction.OUTGOING).evaluator(Evaluators.excludeStartPosition());
        return td.traverse(person);
    }

    public String printMatrixHackers() {
        try (Transaction tx = this.graphDb.beginTx();){
            String output = "Hackers:\n";
            int numberOfHackers = 0;
            Traverser traverser = this.findHackers(this.getNeoNode());
            for (Path hackerPath : traverser) {
                output = output + "At depth " + hackerPath.length() + " => " + hackerPath.endNode().getProperty("name") + "\n";
                ++numberOfHackers;
            }
            output = output + "Number of hackers found: " + numberOfHackers + "\n";
            Object object = output;
            return object;
        }
    }

    private Traverser findHackers(Node startNode) {
        TraversalDescription td = this.graphDb.traversalDescription().breadthFirst().relationships((RelationshipType)RelTypes.CODED_BY, Direction.OUTGOING).relationships((RelationshipType)RelTypes.KNOWS, Direction.OUTGOING).evaluator(Evaluators.includeWhereLastRelationshipTypeIs((RelationshipType)RelTypes.CODED_BY, (RelationshipType[])new RelationshipType[0]));
        return td.traverse(startNode);
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                NewMatrix.this.graphDb.shutdown();
            }
        });
    }

    public static enum RelTypes implements RelationshipType
    {
        NEO_NODE,
        KNOWS,
        CODED_BY;

    }
}

