/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples;

import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ProcedureExample {
    @Context
    public GraphDatabaseService db;

    @Procedure
    public Stream<DenseNode> findDenseNodes(@Name(value="threshold") long threshold) {
        return this.db.getAllNodes().stream().filter(node -> (long)node.getDegree() > threshold).map(DenseNode::new);
    }

    public static class DenseNode {
        public long nodeId;
        public long degree;

        public DenseNode(Node node) {
            this.nodeId = node.getId();
            this.degree = node.getDegree();
        }
    }
}

