/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples.orderedpath;

import java.io.File;
import java.util.ArrayList;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;

public class OrderedPath {
    private static final RelationshipType REL1 = RelationshipType.withName((String)"REL1");
    private static final RelationshipType REL2 = RelationshipType.withName((String)"REL2");
    private static final RelationshipType REL3 = RelationshipType.withName((String)"REL3");
    static final File DB_PATH = new File("target/neo4j-orderedpath-db");
    GraphDatabaseService db;

    public OrderedPath(GraphDatabaseService db) {
        this.db = db;
    }

    public static void main(String[] args) {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
        OrderedPath op = new OrderedPath(db);
        op.shutdownGraph();
    }

    public Node createTheGraph() {
        try (Transaction tx = this.db.beginTx();){
            Node A = this.db.createNode();
            Node B = this.db.createNode();
            Node C = this.db.createNode();
            Node D = this.db.createNode();
            A.createRelationshipTo(C, REL2);
            C.createRelationshipTo(D, REL3);
            A.createRelationshipTo(B, REL1);
            B.createRelationshipTo(C, REL2);
            A.setProperty("name", (Object)"A");
            B.setProperty("name", (Object)"B");
            C.setProperty("name", (Object)"C");
            D.setProperty("name", (Object)"D");
            tx.success();
            Node node = A;
            return node;
        }
    }

    public void shutdownGraph() {
        try {
            if (this.db != null) {
                this.db.shutdown();
            }
        }
        finally {
            this.db = null;
        }
    }

    public TraversalDescription findPaths() {
        final ArrayList<RelationshipType> orderedPathContext = new ArrayList<RelationshipType>();
        orderedPathContext.add(REL1);
        orderedPathContext.add(RelationshipType.withName((String)"REL2"));
        orderedPathContext.add(RelationshipType.withName((String)"REL3"));
        TraversalDescription td = this.db.traversalDescription().evaluator(new Evaluator(){

            public Evaluation evaluate(Path path) {
                if (path.length() == 0) {
                    return Evaluation.EXCLUDE_AND_CONTINUE;
                }
                RelationshipType expectedType = (RelationshipType)orderedPathContext.get(path.length() - 1);
                boolean isExpectedType = path.lastRelationship().isType(expectedType);
                boolean included = path.length() == orderedPathContext.size() && isExpectedType;
                boolean continued = path.length() < orderedPathContext.size() && isExpectedType;
                return Evaluation.of((boolean)included, (boolean)continued);
            }
        }).uniqueness((UniquenessFactory)Uniqueness.NODE_PATH);
        return td;
    }

    String printPaths(TraversalDescription td, Node A) {
        try (Transaction transaction = this.db.beginTx();){
            String output = "";
            Traverser traverser = td.traverse(A);
            PathPrinter pathPrinter = new PathPrinter("name");
            for (Path path : traverser) {
                output = output + Paths.pathToString((Path)path, (Paths.PathDescriptor)pathPrinter);
            }
            output = output + "\n";
            Object object = output;
            return object;
        }
    }

    static class PathPrinter
    implements Paths.PathDescriptor<Path> {
        private final String nodePropertyKey;

        public PathPrinter(String nodePropertyKey) {
            this.nodePropertyKey = nodePropertyKey;
        }

        public String nodeRepresentation(Path path, Node node) {
            return "(" + node.getProperty(this.nodePropertyKey, (Object)"") + ")";
        }

        public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
            String prefix = "--";
            String suffix = "--";
            if (from.equals(relationship.getEndNode())) {
                prefix = "<--";
            } else {
                suffix = "-->";
            }
            return prefix + "[" + relationship.getType().name() + "]" + suffix;
        }
    }
}

