/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples.socnet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.examples.socnet.Person;
import org.neo4j.examples.socnet.StatusUpdate;
import org.neo4j.helpers.collection.PositionedIterator;

class FriendsStatusUpdateIterator
implements Iterator<StatusUpdate> {
    private ArrayList<PositionedIterator<StatusUpdate>> statuses = new ArrayList();
    private StatusUpdateComparator comparator = new StatusUpdateComparator();

    public FriendsStatusUpdateIterator(Person person) {
        for (Person friend : person.getFriends()) {
            Iterator<StatusUpdate> iterator = friend.getStatus().iterator();
            if (!iterator.hasNext()) continue;
            this.statuses.add((PositionedIterator<StatusUpdate>)new PositionedIterator(iterator));
        }
        this.sort();
    }

    @Override
    public boolean hasNext() {
        return this.statuses.size() > 0;
    }

    @Override
    public StatusUpdate next() {
        if (this.statuses.size() == 0) {
            throw new NoSuchElementException();
        }
        PositionedIterator<StatusUpdate> first = this.statuses.get(0);
        StatusUpdate returnVal = (StatusUpdate)first.current();
        if (!first.hasNext()) {
            this.statuses.remove(0);
        } else {
            first.next();
            this.sort();
        }
        return returnVal;
    }

    private void sort() {
        Collections.sort(this.statuses, this.comparator);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Don't know how to do that...");
    }

    private class StatusUpdateComparator
    implements Comparator<PositionedIterator<StatusUpdate>> {
        private StatusUpdateComparator() {
        }

        @Override
        public int compare(PositionedIterator<StatusUpdate> a, PositionedIterator<StatusUpdate> b) {
            return ((StatusUpdate)a.current()).getDate().compareTo(((StatusUpdate)b.current()).getDate());
        }
    }
}

