/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.examples.socnet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.neo4j.examples.socnet.FriendsStatusUpdateIterator;
import org.neo4j.examples.socnet.RelTypes;
import org.neo4j.examples.socnet.StatusUpdate;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;

public class Person {
    static final String NAME = "name";
    private final Node underlyingNode;

    Person(Node personNode) {
        this.underlyingNode = personNode;
    }

    protected Node getUnderlyingNode() {
        return this.underlyingNode;
    }

    public String getName() {
        return (String)this.underlyingNode.getProperty(NAME);
    }

    public int hashCode() {
        return this.underlyingNode.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Person && this.underlyingNode.equals(((Person)o).getUnderlyingNode());
    }

    public String toString() {
        return "Person[" + this.getName() + "]";
    }

    public void addFriend(Person otherPerson) {
        Relationship friendRel;
        if (!this.equals(otherPerson) && (friendRel = this.getFriendRelationshipTo(otherPerson)) == null) {
            this.underlyingNode.createRelationshipTo(otherPerson.getUnderlyingNode(), (RelationshipType)RelTypes.FRIEND);
        }
    }

    public long getNrOfFriends() {
        return Iterables.count(this.getFriends());
    }

    public Iterable<Person> getFriends() {
        return this.getFriendsByDepth(1);
    }

    public void removeFriend(Person otherPerson) {
        Relationship friendRel;
        if (!this.equals(otherPerson) && (friendRel = this.getFriendRelationshipTo(otherPerson)) != null) {
            friendRel.delete();
        }
    }

    public Iterable<Person> getFriendsOfFriends() {
        return this.getFriendsByDepth(2);
    }

    public Iterable<Person> getShortestPathTo(Person otherPerson, int maxDepth) {
        PathFinder finder = GraphAlgoFactory.shortestPath((PathExpander)PathExpanders.forTypeAndDirection((RelationshipType)RelTypes.FRIEND, (Direction)Direction.BOTH), (int)maxDepth);
        Path path = finder.findSinglePath(this.underlyingNode, otherPerson.getUnderlyingNode());
        return this.createPersonsFromNodes(path);
    }

    public Iterable<Person> getFriendRecommendation(int numberOfFriendsToReturn) {
        HashSet friends = new HashSet();
        Iterables.addToCollection(this.getFriends(), friends);
        HashSet friendsOfFriends = new HashSet();
        Iterables.addToCollection(this.getFriendsOfFriends(), friendsOfFriends);
        friendsOfFriends.removeAll(friends);
        ArrayList<RankedPerson> rankedFriends = new ArrayList<RankedPerson>();
        for (Person friend : friendsOfFriends) {
            long rank = this.getNumberOfPathsToPerson(friend);
            rankedFriends.add(new RankedPerson(friend, rank));
        }
        Collections.sort(rankedFriends, new RankedComparer());
        this.trimTo(rankedFriends, numberOfFriendsToReturn);
        return this.onlyFriend(rankedFriends);
    }

    public Iterable<StatusUpdate> getStatus() {
        Relationship firstStatus = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.STATUS, Direction.OUTGOING);
        if (firstStatus == null) {
            return Collections.emptyList();
        }
        TraversalDescription traversal = this.graphDb().traversalDescription().depthFirst().relationships((RelationshipType)RelTypes.NEXT);
        return new IterableWrapper<StatusUpdate, Path>((Iterable)traversal.traverse(firstStatus.getEndNode())){

            protected StatusUpdate underlyingObjectToObject(Path path) {
                return new StatusUpdate(path.endNode());
            }
        };
    }

    public Iterator<StatusUpdate> friendStatuses() {
        return new FriendsStatusUpdateIterator(this);
    }

    public void addStatus(String text) {
        StatusUpdate oldStatus = this.getStatus().iterator().hasNext() ? this.getStatus().iterator().next() : null;
        Node newStatus = this.createNewStatusNode(text);
        if (oldStatus != null) {
            this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.STATUS, Direction.OUTGOING).delete();
            newStatus.createRelationshipTo(oldStatus.getUnderlyingNode(), (RelationshipType)RelTypes.NEXT);
        }
        this.underlyingNode.createRelationshipTo(newStatus, (RelationshipType)RelTypes.STATUS);
    }

    private GraphDatabaseService graphDb() {
        return this.underlyingNode.getGraphDatabase();
    }

    private Node createNewStatusNode(String text) {
        Node newStatus = this.graphDb().createNode();
        newStatus.setProperty("TEXT", (Object)text);
        newStatus.setProperty("DATE", (Object)new Date().getTime());
        return newStatus;
    }

    private void trimTo(ArrayList<RankedPerson> rankedFriends, int numberOfFriendsToReturn) {
        while (rankedFriends.size() > numberOfFriendsToReturn) {
            rankedFriends.remove(rankedFriends.size() - 1);
        }
    }

    private Iterable<Person> onlyFriend(Iterable<RankedPerson> rankedFriends) {
        ArrayList<Person> retVal = new ArrayList<Person>();
        for (RankedPerson person : rankedFriends) {
            retVal.add(person.getPerson());
        }
        return retVal;
    }

    private Relationship getFriendRelationshipTo(Person otherPerson) {
        Node otherNode = otherPerson.getUnderlyingNode();
        for (Relationship rel : this.underlyingNode.getRelationships(new RelationshipType[]{RelTypes.FRIEND})) {
            if (!rel.getOtherNode(this.underlyingNode).equals(otherNode)) continue;
            return rel;
        }
        return null;
    }

    private Iterable<Person> getFriendsByDepth(int depth) {
        TraversalDescription travDesc = this.graphDb().traversalDescription().breadthFirst().relationships((RelationshipType)RelTypes.FRIEND).uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL).evaluator(Evaluators.toDepth((int)depth)).evaluator(Evaluators.excludeStartPosition());
        return this.createPersonsFromPath(travDesc.traverse(this.underlyingNode));
    }

    private IterableWrapper<Person, Path> createPersonsFromPath(Traverser iterableToWrap) {
        return new IterableWrapper<Person, Path>((Iterable)iterableToWrap){

            protected Person underlyingObjectToObject(Path path) {
                return new Person(path.endNode());
            }
        };
    }

    private long getNumberOfPathsToPerson(Person otherPerson) {
        PathFinder finder = GraphAlgoFactory.allPaths((PathExpander)PathExpanders.forTypeAndDirection((RelationshipType)RelTypes.FRIEND, (Direction)Direction.BOTH), (int)2);
        Iterable paths = finder.findAllPaths(this.getUnderlyingNode(), otherPerson.getUnderlyingNode());
        return Iterables.count((Iterable)paths);
    }

    private Iterable<Person> createPersonsFromNodes(Path path) {
        return new IterableWrapper<Person, Node>(path.nodes()){

            protected Person underlyingObjectToObject(Node node) {
                return new Person(node);
            }
        };
    }

    private class RankedComparer
    implements Comparator<RankedPerson> {
        private RankedComparer() {
        }

        @Override
        public int compare(RankedPerson a, RankedPerson b) {
            return Long.compare(b.getRank(), a.getRank());
        }
    }

    private final class RankedPerson {
        final Person person;
        final long rank;

        private RankedPerson(Person person2, long rank) {
            this.person = person2;
            this.rank = rank;
        }

        public Person getPerson() {
            return this.person;
        }

        public long getRank() {
            return this.rank;
        }
    }
}

