/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import com.carrotsearch.hppc.BitSet;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.applications.algorithms.machinery.MutateNodeProperty;
import org.neo4j.gds.applications.algorithms.machinery.MutateStep;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.articulationpoints.ArticulationPointsMutateConfig;
import org.neo4j.gds.config.MutateNodePropertyConfig;

class ArticulationPointsMutateStep
implements MutateStep<BitSet, NodePropertiesWritten> {
    private final MutateNodeProperty mutateNodeProperty;
    private final ArticulationPointsMutateConfig configuration;

    ArticulationPointsMutateStep(MutateNodeProperty mutateNodeProperty, ArticulationPointsMutateConfig configuration) {
        this.mutateNodeProperty = mutateNodeProperty;
        this.configuration = configuration;
    }

    public NodePropertiesWritten execute(final Graph graph, GraphStore graphStore, final BitSet result) {
        LongNodePropertyValues nodeProperties = new LongNodePropertyValues(){

            public long longValue(long nodeId) {
                return result.get(nodeId) ? 1L : 0L;
            }

            public long nodeCount() {
                return graph.nodeCount();
            }
        };
        return this.mutateNodeProperty.mutateNodeProperties(graph, graphStore, (MutateNodePropertyConfig)this.configuration, (NodePropertyValues)nodeProperties);
    }
}

