/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import com.carrotsearch.hppc.BitSet;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmLabel;
import org.neo4j.gds.applications.algorithms.machinery.Label;
import org.neo4j.gds.applications.algorithms.machinery.WriteStep;
import org.neo4j.gds.applications.algorithms.machinery.WriteToDatabase;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.articulationpoints.ArticulationPointsWriteConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.utils.progress.JobId;

class ArticulationPointsWriteStep
implements WriteStep<BitSet, NodePropertiesWritten> {
    private final ArticulationPointsWriteConfig configuration;
    private final WriteToDatabase writeToDatabase;

    public ArticulationPointsWriteStep(ArticulationPointsWriteConfig configuration, WriteToDatabase writeToDatabase) {
        this.configuration = configuration;
        this.writeToDatabase = writeToDatabase;
    }

    public NodePropertiesWritten execute(final Graph graph, GraphStore graphStore, ResultStore resultStore, final BitSet bitSet, JobId jobId) {
        LongNodePropertyValues nodePropertyValues = new LongNodePropertyValues(){

            public long longValue(long nodeId) {
                return bitSet.get(nodeId) ? 1L : 0L;
            }

            public long nodeCount() {
                return graph.nodeCount();
            }
        };
        return this.writeToDatabase.perform(graph, graphStore, resultStore, (WriteConfig)this.configuration, (WritePropertyConfig)this.configuration, (Label)AlgorithmLabel.ArticulationPoints, jobId, (NodePropertyValues)nodePropertyValues);
    }
}

