/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.LongScatterSet;
import com.carrotsearch.hppc.LongSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongToDoubleFunction;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmLabel;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmMachinery;
import org.neo4j.gds.applications.algorithms.machinery.ProgressTrackerCreator;
import org.neo4j.gds.articulationpoints.ArticulationPoints;
import org.neo4j.gds.articulationpoints.ArticulationPointsProgressTaskCreator;
import org.neo4j.gds.beta.pregel.Pregel;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.betweenness.BetweennessCentrality;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityParameters;
import org.neo4j.gds.betweenness.BetwennessCentralityResult;
import org.neo4j.gds.betweenness.ForwardTraverser;
import org.neo4j.gds.betweenness.FullSelectionStrategy;
import org.neo4j.gds.betweenness.RandomDegreeSelectionStrategy;
import org.neo4j.gds.betweenness.SelectionStrategy;
import org.neo4j.gds.bridges.BridgeProgressTaskCreator;
import org.neo4j.gds.bridges.BridgeResult;
import org.neo4j.gds.bridges.Bridges;
import org.neo4j.gds.closeness.CentralityComputer;
import org.neo4j.gds.closeness.ClosenessCentrality;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.closeness.ClosenessCentralityParameters;
import org.neo4j.gds.closeness.ClosenessCentralityResult;
import org.neo4j.gds.closeness.DefaultCentralityComputer;
import org.neo4j.gds.closeness.WassermanFaustCentralityComputer;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.concurrency.Concurrency;
import org.neo4j.gds.core.concurrency.DefaultPool;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.degree.DegreeCentrality;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityParameters;
import org.neo4j.gds.degree.DegreeCentralityResult;
import org.neo4j.gds.harmonic.HarmonicCentrality;
import org.neo4j.gds.harmonic.HarmonicResult;
import org.neo4j.gds.hits.Hits;
import org.neo4j.gds.hits.HitsConfig;
import org.neo4j.gds.hits.HitsProgressTrackerCreator;
import org.neo4j.gds.indirectExposure.IndirectExposure;
import org.neo4j.gds.indirectExposure.IndirectExposureConfig;
import org.neo4j.gds.indirectExposure.IndirectExposureResult;
import org.neo4j.gds.influenceMaximization.CELF;
import org.neo4j.gds.influenceMaximization.CELFResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.pagerank.ArticleRankComputation;
import org.neo4j.gds.pagerank.ArticleRankConfig;
import org.neo4j.gds.pagerank.DegreeFunctions;
import org.neo4j.gds.pagerank.EigenvectorComputation;
import org.neo4j.gds.pagerank.EigenvectorConfig;
import org.neo4j.gds.pagerank.PageRankAlgorithm;
import org.neo4j.gds.pagerank.PageRankComputation;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankVariant;
import org.neo4j.gds.pagerank.RankConfig;
import org.neo4j.gds.termination.TerminationFlag;

public class CentralityAlgorithms {
    private final AlgorithmMachinery algorithmMachinery = new AlgorithmMachinery();
    private final ProgressTrackerCreator progressTrackerCreator;
    private final TerminationFlag terminationFlag;

    public CentralityAlgorithms(ProgressTrackerCreator progressTrackerCreator, TerminationFlag terminationFlag) {
        this.progressTrackerCreator = progressTrackerCreator;
        this.terminationFlag = terminationFlag;
    }

    PageRankResult articleRank(Graph graph, ArticleRankConfig configuration) {
        Task task = Pregel.progressTask((Graph)graph, (PregelConfig)configuration, (String)AlgorithmLabel.ArticleRank.asString());
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, task);
        return this.articleRank(graph, configuration, progressTracker);
    }

    public PageRankResult articleRank(Graph graph, ArticleRankConfig configuration, ProgressTracker progressTracker) {
        ArticleRankComputation<ArticleRankConfig> articleRankComputation = this.articleRankComputation(graph, configuration);
        PageRankAlgorithm articleRank = new PageRankAlgorithm(graph, (RankConfig)configuration, articleRankComputation, PageRankVariant.ARTICLE_RANK, DefaultPool.INSTANCE, progressTracker, this.terminationFlag);
        return articleRank.compute();
    }

    BitSet articulationPoints(Graph graph, AlgoBaseConfig configuration) {
        Task task = ArticulationPointsProgressTaskCreator.progressTask((long)graph.nodeCount());
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker(configuration, task);
        ArticulationPoints algorithm = new ArticulationPoints(graph, progressTracker);
        return (BitSet)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true, configuration.concurrency());
    }

    BetwennessCentralityResult betweennessCentrality(Graph graph, BetweennessCentralityBaseConfig configuration) {
        return this.betweennessCentrality(graph, configuration.toParameters(), samplingSize -> {
            LeafTask task = Tasks.leaf((String)AlgorithmLabel.BetweennessCentrality.asString(), (long)samplingSize.orElse(graph.nodeCount()));
            return this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, (Task)task);
        });
    }

    public BetwennessCentralityResult betweennessCentrality(Graph graph, BetweennessCentralityParameters parameters, Function<Optional<Long>, ProgressTracker> progressTrackerFromSamplingSize) {
        Optional samplingSize = parameters.samplingSize();
        Optional samplingSeed = parameters.samplingSeed();
        FullSelectionStrategy selectionStrategy = samplingSize.isPresent() && (Long)samplingSize.get() < graph.nodeCount() ? new RandomDegreeSelectionStrategy(((Long)samplingSize.get()).longValue(), samplingSeed) : new FullSelectionStrategy();
        ForwardTraverser.Factory traverserFactory = parameters.hasRelationshipWeightProperty() ? ForwardTraverser.Factory.weighted() : ForwardTraverser.Factory.unweighted();
        ProgressTracker progressTracker = progressTrackerFromSamplingSize.apply(samplingSize);
        BetweennessCentrality algorithm = new BetweennessCentrality(graph, (SelectionStrategy)selectionStrategy, traverserFactory, DefaultPool.INSTANCE, parameters.concurrency(), progressTracker, this.terminationFlag);
        return (BetwennessCentralityResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true, parameters.concurrency());
    }

    BridgeResult bridges(Graph graph, AlgoBaseConfig configuration) {
        Task task = BridgeProgressTaskCreator.progressTask((long)graph.nodeCount());
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker(configuration, task);
        Bridges algorithm = new Bridges(graph, progressTracker);
        return (BridgeResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true, configuration.concurrency());
    }

    public CELFResult celf(Graph graph, InfluenceMaximizationBaseConfig configuration) {
        Task task = Tasks.task((String)AlgorithmLabel.CELF.asString(), (Task)Tasks.leaf((String)"Greedy", (long)graph.nodeCount()), (Task[])new Task[]{Tasks.leaf((String)"LazyForwarding", (long)(configuration.seedSetSize() - 1))});
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, task);
        CELF algorithm = new CELF(graph, configuration.toParameters(), DefaultPool.INSTANCE, progressTracker);
        return (CELFResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true, configuration.concurrency());
    }

    ClosenessCentralityResult closenessCentrality(Graph graph, ClosenessCentralityBaseConfig configuration) {
        ClosenessCentralityParameters parameters = configuration.toParameters();
        WassermanFaustCentralityComputer centralityComputer = parameters.useWassermanFaust() ? new WassermanFaustCentralityComputer(graph.nodeCount()) : new DefaultCentralityComputer();
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, Tasks.task((String)AlgorithmLabel.ClosenessCentrality.asString(), (Task)Tasks.leaf((String)"Farness computation", (long)(graph.nodeCount() * graph.nodeCount())), (Task[])new Task[]{Tasks.leaf((String)"Closeness computation", (long)graph.nodeCount())}));
        ClosenessCentrality algorithm = new ClosenessCentrality(graph, parameters.concurrency(), (CentralityComputer)centralityComputer, DefaultPool.INSTANCE, progressTracker, this.terminationFlag);
        return (ClosenessCentralityResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true, configuration.concurrency());
    }

    DegreeCentralityResult degreeCentrality(Graph graph, DegreeCentralityConfig configuration) {
        DegreeCentralityParameters parameters = configuration.toParameters();
        LeafTask task = Tasks.leaf((String)AlgorithmLabel.DegreeCentrality.asString(), (long)graph.nodeCount());
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, (Task)task);
        DegreeCentrality algorithm = new DegreeCentrality(graph, DefaultPool.INSTANCE, parameters.concurrency(), parameters.orientation(), parameters.hasRelationshipWeightProperty(), parameters.minBatchSize(), progressTracker);
        return (DegreeCentralityResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true, configuration.concurrency());
    }

    PageRankResult eigenVector(Graph graph, EigenvectorConfig configuration) {
        Task task = Pregel.progressTask((Graph)graph, (PregelConfig)configuration, (String)AlgorithmLabel.EigenVector.asString());
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, task);
        return this.eigenVector(graph, configuration, progressTracker);
    }

    public PageRankResult eigenVector(Graph graph, EigenvectorConfig configuration, ProgressTracker progressTracker) {
        EigenvectorComputation<EigenvectorConfig> eigenvectorComputation = this.eigenvectorComputation(graph, configuration);
        PageRankAlgorithm eigenvector = new PageRankAlgorithm(graph, (RankConfig)configuration, eigenvectorComputation, PageRankVariant.EIGENVECTOR, DefaultPool.INSTANCE, progressTracker, this.terminationFlag);
        return eigenvector.compute();
    }

    HarmonicResult harmonicCentrality(Graph graph, AlgoBaseConfig configuration) {
        LeafTask task = Tasks.leaf((String)AlgorithmLabel.HarmonicCentrality.asString());
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker(configuration, (Task)task);
        HarmonicCentrality algorithm = new HarmonicCentrality(graph, configuration.concurrency(), DefaultPool.INSTANCE, progressTracker, this.terminationFlag);
        return (HarmonicResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true, configuration.concurrency());
    }

    PregelResult hits(Graph graph, HitsConfig configuration) {
        Task task = HitsProgressTrackerCreator.progressTask((long)graph.nodeCount(), (int)configuration.maxIterations(), (String)AlgorithmLabel.HITS.asString());
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, task);
        Hits algorithm = new Hits(graph, configuration, DefaultPool.INSTANCE, progressTracker);
        return (PregelResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true, configuration.concurrency());
    }

    IndirectExposureResult indirectExposure(Graph graph, IndirectExposureConfig configuration) {
        Task task = Tasks.task((String)AlgorithmLabel.IndirectExposure.asString(), (Task)Tasks.leaf((String)"TotalTransfers", (long)graph.nodeCount()), (Task[])new Task[]{Pregel.progressTask((Graph)graph, (PregelConfig)configuration, (String)"ExposurePropagation")});
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, task);
        IndirectExposure algorithm = new IndirectExposure(graph, configuration, DefaultPool.INSTANCE, progressTracker);
        return (IndirectExposureResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true, configuration.concurrency());
    }

    public PageRankResult pageRank(Graph graph, PageRankConfig configuration) {
        Task task = Pregel.progressTask((Graph)graph, (PregelConfig)configuration, (String)AlgorithmLabel.PageRank.asString());
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, task);
        return this.pageRank(graph, configuration, progressTracker);
    }

    public PageRankResult pageRank(Graph graph, PageRankConfig configuration, ProgressTracker progressTracker) {
        PageRankComputation<PageRankConfig> pageRankComputation = this.pageRankComputation(graph, configuration);
        PageRankAlgorithm pageRank = new PageRankAlgorithm(graph, (RankConfig)configuration, pageRankComputation, PageRankVariant.PAGE_RANK, DefaultPool.INSTANCE, progressTracker, this.terminationFlag);
        return pageRank.compute();
    }

    private ArticleRankComputation<ArticleRankConfig> articleRankComputation(Graph graph, ArticleRankConfig configuration) {
        LongToDoubleFunction degreeFunction = DegreeFunctions.pageRankDegreeFunction((Graph)graph, (boolean)configuration.hasRelationshipWeightProperty(), (Concurrency)configuration.concurrency());
        LongScatterSet mappedSourceNodes = new LongScatterSet(configuration.sourceNodes().size());
        configuration.sourceNodes().stream().mapToLong(arg_0 -> ((Graph)graph).toMappedNodeId(arg_0)).forEach(arg_0 -> ((LongScatterSet)mappedSourceNodes).add(arg_0));
        double avgDegree = DegreeFunctions.averageDegree((Graph)graph, (Concurrency)configuration.concurrency());
        return new ArticleRankComputation(configuration, (LongSet)mappedSourceNodes, degreeFunction, avgDegree);
    }

    private EigenvectorComputation<EigenvectorConfig> eigenvectorComputation(Graph graph, EigenvectorConfig configuration) {
        LongScatterSet mappedSourceNodes = new LongScatterSet(configuration.sourceNodes().size());
        configuration.sourceNodes().stream().mapToLong(arg_0 -> ((Graph)graph).toMappedNodeId(arg_0)).forEach(arg_0 -> ((LongScatterSet)mappedSourceNodes).add(arg_0));
        boolean hasRelationshipWeightProperty = configuration.hasRelationshipWeightProperty();
        Concurrency concurrency = configuration.concurrency();
        LongToDoubleFunction degreeFunction = DegreeFunctions.eigenvectorDegreeFunction((Graph)graph, (boolean)hasRelationshipWeightProperty, (Concurrency)concurrency);
        return new EigenvectorComputation(graph.nodeCount(), configuration, (LongSet)mappedSourceNodes, degreeFunction);
    }

    private PageRankComputation<PageRankConfig> pageRankComputation(Graph graph, PageRankConfig configuration) {
        LongToDoubleFunction degreeFunction = DegreeFunctions.pageRankDegreeFunction((Graph)graph, (boolean)configuration.hasRelationshipWeightProperty(), (Concurrency)configuration.concurrency());
        LongScatterSet mappedSourceNodes = new LongScatterSet(configuration.sourceNodes().size());
        configuration.sourceNodes().stream().mapToLong(arg_0 -> ((Graph)graph).toMappedNodeId(arg_0)).forEach(arg_0 -> ((LongScatterSet)mappedSourceNodes).add(arg_0));
        return new PageRankComputation(configuration, (LongSet)mappedSourceNodes, degreeFunction);
    }
}

