/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import org.neo4j.gds.applications.algorithms.machinery.AlgorithmEstimationTemplate;
import org.neo4j.gds.applications.algorithms.machinery.MemoryEstimateResult;
import org.neo4j.gds.articulationpoints.ArticulationPointsBaseConfig;
import org.neo4j.gds.articulationpoints.ArticulationPointsMemoryEstimateDefinition;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityMemoryEstimateDefinition;
import org.neo4j.gds.bridges.BridgesBaseConfig;
import org.neo4j.gds.bridges.BridgesMemoryEstimateDefinition;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.degree.DegreeCentralityAlgorithmEstimateDefinition;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.gds.hits.HitsConfig;
import org.neo4j.gds.hits.HitsMemoryEstimateDefinition;
import org.neo4j.gds.indirectExposure.IndirectExposureMemoryEstimationDefinition;
import org.neo4j.gds.influenceMaximization.CELFMemoryEstimateDefinition;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.mem.MemoryEstimation;
import org.neo4j.gds.pagerank.PageRankMemoryEstimateDefinition;
import org.neo4j.gds.pagerank.RankConfig;

public class CentralityAlgorithmsEstimationModeBusinessFacade {
    private final AlgorithmEstimationTemplate algorithmEstimationTemplate;

    public CentralityAlgorithmsEstimationModeBusinessFacade(AlgorithmEstimationTemplate algorithmEstimationTemplate) {
        this.algorithmEstimationTemplate = algorithmEstimationTemplate;
    }

    public MemoryEstimation articulationPoints() {
        return new ArticulationPointsMemoryEstimateDefinition().memoryEstimation();
    }

    public MemoryEstimateResult articulationPoints(ArticulationPointsBaseConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.articulationPoints();
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }

    public MemoryEstimation betweennessCentrality(RelationshipWeightConfig configuration) {
        return new BetweennessCentralityMemoryEstimateDefinition(configuration.hasRelationshipWeightProperty()).memoryEstimation();
    }

    public MemoryEstimateResult betweennessCentrality(BetweennessCentralityBaseConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.betweennessCentrality((RelationshipWeightConfig)configuration);
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }

    MemoryEstimation bridges() {
        return new BridgesMemoryEstimateDefinition().memoryEstimation();
    }

    public MemoryEstimateResult bridges(BridgesBaseConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.bridges();
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }

    public MemoryEstimation celf(InfluenceMaximizationBaseConfig configuration) {
        return new CELFMemoryEstimateDefinition(configuration.toParameters()).memoryEstimation();
    }

    public MemoryEstimateResult celf(InfluenceMaximizationBaseConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.celf(configuration);
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }

    public MemoryEstimation closenessCentrality(ClosenessCentralityBaseConfig ignored) {
        throw new MemoryEstimationNotImplementedException();
    }

    public MemoryEstimation degreeCentrality(RelationshipWeightConfig configuration) {
        return new DegreeCentralityAlgorithmEstimateDefinition(configuration.hasRelationshipWeightProperty()).memoryEstimation();
    }

    public MemoryEstimateResult degreeCentrality(DegreeCentralityConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.degreeCentrality((RelationshipWeightConfig)configuration);
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }

    public MemoryEstimation harmonicCentrality() {
        throw new MemoryEstimationNotImplementedException();
    }

    public MemoryEstimation pageRank() {
        return new PageRankMemoryEstimateDefinition().memoryEstimation();
    }

    public MemoryEstimateResult pageRank(RankConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.pageRank();
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }

    MemoryEstimation indirectExposure() {
        return new IndirectExposureMemoryEstimationDefinition().memoryEstimation();
    }

    public MemoryEstimateResult hits(HitsConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.hits();
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }

    public MemoryEstimation hits() {
        return new HitsMemoryEstimateDefinition().memoryEstimation();
    }
}

