/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import com.carrotsearch.hppc.BitSet;
import java.util.List;
import java.util.Optional;
import org.neo4j.gds.api.GraphName;
import org.neo4j.gds.applications.algorithms.centrality.ArticulationPointsMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.BetweennessCentralityMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.CelfMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithms;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsEstimationModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.ClosenessCentralityMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.DegreeCentralityMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.HarmonicCentralityMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.HitsETLHook;
import org.neo4j.gds.applications.algorithms.centrality.HitsHookGenerator;
import org.neo4j.gds.applications.algorithms.centrality.HitsMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.IndirectExposureMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.PageRankMutateStep;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmLabel;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmProcessingTemplateConvenience;
import org.neo4j.gds.applications.algorithms.machinery.Label;
import org.neo4j.gds.applications.algorithms.machinery.MutateNodeProperty;
import org.neo4j.gds.applications.algorithms.machinery.MutateStep;
import org.neo4j.gds.applications.algorithms.machinery.ResultBuilder;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.articulationpoints.ArticulationPointsMutateConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityMutateConfig;
import org.neo4j.gds.betweenness.BetwennessCentralityResult;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.closeness.ClosenessCentralityMutateConfig;
import org.neo4j.gds.closeness.ClosenessCentralityResult;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityMutateConfig;
import org.neo4j.gds.degree.DegreeCentralityResult;
import org.neo4j.gds.harmonic.HarmonicCentralityMutateConfig;
import org.neo4j.gds.harmonic.HarmonicResult;
import org.neo4j.gds.hits.HitsConfig;
import org.neo4j.gds.indirectExposure.IndirectExposureConfig;
import org.neo4j.gds.indirectExposure.IndirectExposureMutateConfig;
import org.neo4j.gds.indirectExposure.IndirectExposureResult;
import org.neo4j.gds.influenceMaximization.CELFResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationMutateConfig;
import org.neo4j.gds.pagerank.ArticleRankConfig;
import org.neo4j.gds.pagerank.ArticleRankMutateConfig;
import org.neo4j.gds.pagerank.EigenvectorConfig;
import org.neo4j.gds.pagerank.EigenvectorMutateConfig;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankMutateConfig;
import org.neo4j.gds.pagerank.PageRankResult;

public class CentralityAlgorithmsMutateModeBusinessFacade {
    private final CentralityAlgorithmsEstimationModeBusinessFacade estimation;
    private final CentralityAlgorithms algorithms;
    private final AlgorithmProcessingTemplateConvenience algorithmProcessingTemplateConvenience;
    private final MutateNodeProperty mutateNodeProperty;
    private final HitsHookGenerator hitsHookGenerator;

    public CentralityAlgorithmsMutateModeBusinessFacade(CentralityAlgorithmsEstimationModeBusinessFacade estimation, CentralityAlgorithms algorithms, AlgorithmProcessingTemplateConvenience algorithmProcessingTemplateConvenience, MutateNodeProperty mutateNodeProperty, HitsHookGenerator hitsHookGenerator) {
        this.estimation = estimation;
        this.algorithms = algorithms;
        this.algorithmProcessingTemplateConvenience = algorithmProcessingTemplateConvenience;
        this.mutateNodeProperty = mutateNodeProperty;
        this.hitsHookGenerator = hitsHookGenerator;
    }

    public <RESULT> RESULT articleRank(GraphName graphName, ArticleRankMutateConfig configuration, ResultBuilder<ArticleRankMutateConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankMutateStep<ArticleRankMutateConfig> mutateStep = new PageRankMutateStep<ArticleRankMutateConfig>(this.mutateNodeProperty, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInMutateMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ArticleRank, this.estimation::pageRank, (graph, __) -> this.algorithms.articleRank(graph, (ArticleRankConfig)configuration), mutateStep, resultBuilder);
    }

    public <RESULT> RESULT articulationPoints(GraphName graphName, ArticulationPointsMutateConfig configuration, ResultBuilder<ArticulationPointsMutateConfig, BitSet, RESULT, NodePropertiesWritten> resultBuilder) {
        ArticulationPointsMutateStep mutateStep = new ArticulationPointsMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInMutateMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ArticulationPoints, this.estimation::articulationPoints, (graph, __) -> this.algorithms.articulationPoints(graph, (AlgoBaseConfig)configuration), (MutateStep)mutateStep, resultBuilder);
    }

    public <RESULT> RESULT betweennessCentrality(GraphName graphName, BetweennessCentralityMutateConfig configuration, ResultBuilder<BetweennessCentralityMutateConfig, BetwennessCentralityResult, RESULT, NodePropertiesWritten> resultBuilder) {
        BetweennessCentralityMutateStep mutateStep = new BetweennessCentralityMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInMutateMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.BetweennessCentrality, () -> this.estimation.betweennessCentrality((RelationshipWeightConfig)configuration), (graph, __) -> this.algorithms.betweennessCentrality(graph, (BetweennessCentralityBaseConfig)configuration), (MutateStep)mutateStep, resultBuilder);
    }

    public <RESULT> RESULT celf(GraphName graphName, InfluenceMaximizationMutateConfig configuration, ResultBuilder<InfluenceMaximizationMutateConfig, CELFResult, RESULT, NodePropertiesWritten> resultBuilder) {
        CelfMutateStep mutateStep = new CelfMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInMutateMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.CELF, () -> this.estimation.celf((InfluenceMaximizationBaseConfig)configuration), (graph, __) -> this.algorithms.celf(graph, (InfluenceMaximizationBaseConfig)configuration), (MutateStep)mutateStep, resultBuilder);
    }

    public <RESULT> RESULT closenessCentrality(GraphName graphName, ClosenessCentralityMutateConfig configuration, ResultBuilder<ClosenessCentralityMutateConfig, ClosenessCentralityResult, RESULT, NodePropertiesWritten> resultBuilder) {
        ClosenessCentralityMutateStep mutateStep = new ClosenessCentralityMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInMutateMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ClosenessCentrality, () -> this.estimation.closenessCentrality((ClosenessCentralityBaseConfig)configuration), (graph, __) -> this.algorithms.closenessCentrality(graph, (ClosenessCentralityBaseConfig)configuration), (MutateStep)mutateStep, resultBuilder);
    }

    public <RESULT> RESULT degreeCentrality(GraphName graphName, DegreeCentralityMutateConfig configuration, ResultBuilder<DegreeCentralityMutateConfig, DegreeCentralityResult, RESULT, NodePropertiesWritten> resultBuilder) {
        DegreeCentralityMutateStep mutateStep = new DegreeCentralityMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInMutateMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.DegreeCentrality, () -> this.estimation.degreeCentrality((RelationshipWeightConfig)configuration), (graph, __) -> this.algorithms.degreeCentrality(graph, (DegreeCentralityConfig)configuration), (MutateStep)mutateStep, resultBuilder);
    }

    public <RESULT> RESULT eigenVector(GraphName graphName, EigenvectorMutateConfig configuration, ResultBuilder<EigenvectorMutateConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankMutateStep<EigenvectorMutateConfig> mutateStep = new PageRankMutateStep<EigenvectorMutateConfig>(this.mutateNodeProperty, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInMutateMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.EigenVector, this.estimation::pageRank, (graph, __) -> this.algorithms.eigenVector(graph, (EigenvectorConfig)configuration), mutateStep, resultBuilder);
    }

    public <RESULT> RESULT harmonicCentrality(GraphName graphName, HarmonicCentralityMutateConfig configuration, ResultBuilder<HarmonicCentralityMutateConfig, HarmonicResult, RESULT, NodePropertiesWritten> resultBuilder) {
        HarmonicCentralityMutateStep mutateStep = new HarmonicCentralityMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInMutateMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.HarmonicCentrality, this.estimation::harmonicCentrality, (graph, __) -> this.algorithms.harmonicCentrality(graph, (AlgoBaseConfig)configuration), (MutateStep)mutateStep, resultBuilder);
    }

    public <RESULT> RESULT pageRank(GraphName graphName, PageRankMutateConfig configuration, ResultBuilder<PageRankMutateConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankMutateStep<PageRankMutateConfig> mutateStep = new PageRankMutateStep<PageRankMutateConfig>(this.mutateNodeProperty, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInMutateMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.PageRank, this.estimation::pageRank, (graph, __) -> this.algorithms.pageRank(graph, (PageRankConfig)configuration), mutateStep, resultBuilder);
    }

    public <RESULT> RESULT indirectExposure(GraphName graphName, IndirectExposureMutateConfig configuration, ResultBuilder<IndirectExposureMutateConfig, IndirectExposureResult, RESULT, NodePropertiesWritten> resultBuilder) {
        IndirectExposureMutateStep mutateStep = new IndirectExposureMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInMutateMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.IndirectExposure, this.estimation::indirectExposure, (graph, __) -> this.algorithms.indirectExposure(graph, (IndirectExposureConfig)configuration), (MutateStep)mutateStep, resultBuilder);
    }

    public <RESULT> RESULT hits(GraphName graphName, HitsConfig configuration, ResultBuilder<HitsConfig, PregelResult, RESULT, NodePropertiesWritten> resultBuilder) {
        HitsMutateStep mutateStep = new HitsMutateStep(this.mutateNodeProperty, configuration);
        HitsETLHook hook = this.hitsHookGenerator.createETLHook(configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processAlgorithmInMutateMode(Optional.empty(), graphName, (AlgoBaseConfig)configuration, Optional.empty(), Optional.of(List.of(hook)), (Label)AlgorithmLabel.HITS, this.estimation::hits, (graph, __) -> this.algorithms.hits(graph, configuration), (MutateStep)mutateStep, resultBuilder);
    }
}

