/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import com.carrotsearch.hppc.BitSet;
import java.util.List;
import java.util.Optional;
import org.neo4j.gds.algorithms.centrality.CentralityAlgorithmResult;
import org.neo4j.gds.api.GraphName;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithms;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsEstimationModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.HitsETLHook;
import org.neo4j.gds.applications.algorithms.centrality.HitsHookGenerator;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmLabel;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmProcessingTemplateConvenience;
import org.neo4j.gds.applications.algorithms.machinery.Label;
import org.neo4j.gds.applications.algorithms.machinery.StatsResultBuilder;
import org.neo4j.gds.articulationpoints.ArticulationPointsStatsConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityStatsConfig;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.closeness.ClosenessCentralityStatsConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityStatsConfig;
import org.neo4j.gds.harmonic.HarmonicCentralityStatsConfig;
import org.neo4j.gds.hits.HitsConfig;
import org.neo4j.gds.influenceMaximization.CELFResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationStatsConfig;
import org.neo4j.gds.pagerank.ArticleRankConfig;
import org.neo4j.gds.pagerank.ArticleRankStatsConfig;
import org.neo4j.gds.pagerank.EigenvectorConfig;
import org.neo4j.gds.pagerank.EigenvectorStatsConfig;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankStatsConfig;

public class CentralityAlgorithmsStatsModeBusinessFacade {
    private final CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade;
    private final CentralityAlgorithms centralityAlgorithms;
    private final AlgorithmProcessingTemplateConvenience algorithmProcessingTemplateConvenience;
    private final HitsHookGenerator hitsHookGenerator;

    CentralityAlgorithmsStatsModeBusinessFacade(CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade, CentralityAlgorithms centralityAlgorithms, AlgorithmProcessingTemplateConvenience algorithmProcessingTemplateConvenience, HitsHookGenerator hitsHookGenerator) {
        this.estimationFacade = estimationFacade;
        this.centralityAlgorithms = centralityAlgorithms;
        this.algorithmProcessingTemplateConvenience = algorithmProcessingTemplateConvenience;
        this.hitsHookGenerator = hitsHookGenerator;
    }

    public <RESULT> RESULT articleRank(GraphName graphName, ArticleRankStatsConfig configuration, StatsResultBuilder<PageRankResult, RESULT> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStatsMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ArticleRank, this.estimationFacade::pageRank, (graph, __) -> this.centralityAlgorithms.articleRank(graph, (ArticleRankConfig)configuration), resultBuilder);
    }

    public <RESULT> RESULT articulationPoints(GraphName graphName, ArticulationPointsStatsConfig configuration, StatsResultBuilder<BitSet, RESULT> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStatsMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ArticulationPoints, this.estimationFacade::articulationPoints, (graph, __) -> this.centralityAlgorithms.articulationPoints(graph, (AlgoBaseConfig)configuration), resultBuilder);
    }

    public <RESULT> RESULT betweennessCentrality(GraphName graphName, BetweennessCentralityStatsConfig configuration, StatsResultBuilder<CentralityAlgorithmResult, RESULT> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStatsMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.BetweennessCentrality, () -> this.estimationFacade.betweennessCentrality((RelationshipWeightConfig)configuration), (graph, __) -> this.centralityAlgorithms.betweennessCentrality(graph, (BetweennessCentralityBaseConfig)configuration), resultBuilder);
    }

    public <RESULT> RESULT celf(GraphName graphName, InfluenceMaximizationStatsConfig configuration, StatsResultBuilder<CELFResult, RESULT> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStatsMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.CELF, () -> this.estimationFacade.celf((InfluenceMaximizationBaseConfig)configuration), (graph, __) -> this.centralityAlgorithms.celf(graph, (InfluenceMaximizationBaseConfig)configuration), resultBuilder);
    }

    public <RESULT> RESULT closenessCentrality(GraphName graphName, ClosenessCentralityStatsConfig configuration, StatsResultBuilder<CentralityAlgorithmResult, RESULT> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStatsMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ClosenessCentrality, () -> this.estimationFacade.closenessCentrality((ClosenessCentralityBaseConfig)configuration), (graph, __) -> this.centralityAlgorithms.closenessCentrality(graph, (ClosenessCentralityBaseConfig)configuration), resultBuilder);
    }

    public <RESULT> RESULT degreeCentrality(GraphName graphName, DegreeCentralityStatsConfig configuration, StatsResultBuilder<CentralityAlgorithmResult, RESULT> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStatsMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.DegreeCentrality, () -> this.estimationFacade.degreeCentrality((RelationshipWeightConfig)configuration), (graph, __) -> this.centralityAlgorithms.degreeCentrality(graph, (DegreeCentralityConfig)configuration), resultBuilder);
    }

    public <RESULT> RESULT eigenVector(GraphName graphName, EigenvectorStatsConfig configuration, StatsResultBuilder<PageRankResult, RESULT> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStatsMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.EigenVector, this.estimationFacade::pageRank, (graph, __) -> this.centralityAlgorithms.eigenVector(graph, (EigenvectorConfig)configuration), resultBuilder);
    }

    public <RESULT> RESULT harmonicCentrality(GraphName graphName, HarmonicCentralityStatsConfig configuration, StatsResultBuilder<CentralityAlgorithmResult, RESULT> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStatsMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.HarmonicCentrality, this.estimationFacade::harmonicCentrality, (graph, __) -> this.centralityAlgorithms.harmonicCentrality(graph, (AlgoBaseConfig)configuration), resultBuilder);
    }

    public <RESULT> RESULT pageRank(GraphName graphName, PageRankStatsConfig configuration, StatsResultBuilder<PageRankResult, RESULT> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStatsMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.PageRank, this.estimationFacade::pageRank, (graph, __) -> this.centralityAlgorithms.pageRank(graph, (PageRankConfig)configuration), resultBuilder);
    }

    public <RESULT> RESULT hits(GraphName graphName, HitsConfig configuration, StatsResultBuilder<PregelResult, RESULT> resultBuilder) {
        HitsETLHook hitsETLHook = this.hitsHookGenerator.createETLHook(configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processAlgorithmInStatsMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.HITS, this.estimationFacade::hits, (graph, __) -> this.centralityAlgorithms.hits(graph, configuration), resultBuilder, Optional.empty(), Optional.of(List.of(hitsETLHook)), Optional.empty());
    }
}

