/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import com.carrotsearch.hppc.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.algorithms.centrality.CentralityAlgorithmResult;
import org.neo4j.gds.api.GraphName;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithms;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsEstimationModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.HitsETLHook;
import org.neo4j.gds.applications.algorithms.centrality.HitsHookGenerator;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmLabel;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmProcessingTemplateConvenience;
import org.neo4j.gds.applications.algorithms.machinery.Label;
import org.neo4j.gds.applications.algorithms.machinery.StreamResultBuilder;
import org.neo4j.gds.articulationpoints.ArticulationPointsStreamConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityStreamConfig;
import org.neo4j.gds.bridges.BridgeResult;
import org.neo4j.gds.bridges.BridgesStreamConfig;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.closeness.ClosenessCentralityStreamConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityStreamConfig;
import org.neo4j.gds.harmonic.HarmonicCentralityStreamConfig;
import org.neo4j.gds.harmonic.HarmonicResult;
import org.neo4j.gds.hits.HitsConfig;
import org.neo4j.gds.influenceMaximization.CELFResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationStreamConfig;
import org.neo4j.gds.pagerank.ArticleRankConfig;
import org.neo4j.gds.pagerank.ArticleRankStreamConfig;
import org.neo4j.gds.pagerank.EigenvectorConfig;
import org.neo4j.gds.pagerank.EigenvectorStreamConfig;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankStreamConfig;

public class CentralityAlgorithmsStreamModeBusinessFacade {
    private final CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade;
    private final CentralityAlgorithms centralityAlgorithms;
    private final AlgorithmProcessingTemplateConvenience algorithmProcessingTemplateConvenience;
    private final HitsHookGenerator hitsHookGenerator;

    CentralityAlgorithmsStreamModeBusinessFacade(CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade, CentralityAlgorithms centralityAlgorithms, AlgorithmProcessingTemplateConvenience algorithmProcessingTemplateConvenience, HitsHookGenerator hitsHookGenerator) {
        this.estimationFacade = estimationFacade;
        this.centralityAlgorithms = centralityAlgorithms;
        this.algorithmProcessingTemplateConvenience = algorithmProcessingTemplateConvenience;
        this.hitsHookGenerator = hitsHookGenerator;
    }

    public <RESULT> Stream<RESULT> articleRank(GraphName graphName, ArticleRankStreamConfig configuration, StreamResultBuilder<PageRankResult, RESULT> streamResultBuilder) {
        return this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ArticleRank, this.estimationFacade::pageRank, (graph, __) -> this.centralityAlgorithms.articleRank(graph, (ArticleRankConfig)configuration), streamResultBuilder);
    }

    public <RESULT> Stream<RESULT> betweennessCentrality(GraphName graphName, BetweennessCentralityStreamConfig configuration, StreamResultBuilder<CentralityAlgorithmResult, RESULT> streamResultBuilder) {
        return this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.BetweennessCentrality, () -> this.estimationFacade.betweennessCentrality((RelationshipWeightConfig)configuration), (graph, __) -> this.centralityAlgorithms.betweennessCentrality(graph, (BetweennessCentralityBaseConfig)configuration), streamResultBuilder);
    }

    public <RESULT> Stream<RESULT> articulationPoints(GraphName graphName, ArticulationPointsStreamConfig configuration, StreamResultBuilder<BitSet, RESULT> streamResultBuilder) {
        return this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ArticulationPoints, this.estimationFacade::articulationPoints, (graph, __) -> this.centralityAlgorithms.articulationPoints(graph, (AlgoBaseConfig)configuration), streamResultBuilder);
    }

    public <RESULT> Stream<RESULT> bridges(GraphName graphName, BridgesStreamConfig configuration, StreamResultBuilder<BridgeResult, RESULT> streamResultBuilder) {
        return this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.Bridges, this.estimationFacade::bridges, (graph, __) -> this.centralityAlgorithms.bridges(graph, (AlgoBaseConfig)configuration), streamResultBuilder);
    }

    public <RESULT> Stream<RESULT> celf(GraphName graphName, InfluenceMaximizationStreamConfig configuration, StreamResultBuilder<CELFResult, RESULT> streamResultBuilder) {
        return this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.CELF, () -> this.estimationFacade.celf((InfluenceMaximizationBaseConfig)configuration), (graph, __) -> this.centralityAlgorithms.celf(graph, (InfluenceMaximizationBaseConfig)configuration), streamResultBuilder);
    }

    public <RESULT> Stream<RESULT> closenessCentrality(GraphName graphName, ClosenessCentralityStreamConfig configuration, StreamResultBuilder<CentralityAlgorithmResult, RESULT> streamResultBuilder) {
        return this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ClosenessCentrality, () -> this.estimationFacade.closenessCentrality((ClosenessCentralityBaseConfig)configuration), (graph, __) -> this.centralityAlgorithms.closenessCentrality(graph, (ClosenessCentralityBaseConfig)configuration), streamResultBuilder);
    }

    public <RESULT> Stream<RESULT> degreeCentrality(GraphName graphName, DegreeCentralityStreamConfig configuration, StreamResultBuilder<CentralityAlgorithmResult, RESULT> streamResultBuilder) {
        return this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.DegreeCentrality, () -> this.estimationFacade.degreeCentrality((RelationshipWeightConfig)configuration), (graph, __) -> this.centralityAlgorithms.degreeCentrality(graph, (DegreeCentralityConfig)configuration), streamResultBuilder);
    }

    public <RESULT> Stream<RESULT> eigenvector(GraphName graphName, EigenvectorStreamConfig configuration, StreamResultBuilder<PageRankResult, RESULT> streamResultBuilder) {
        return this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.EigenVector, this.estimationFacade::pageRank, (graph, __) -> this.centralityAlgorithms.eigenVector(graph, (EigenvectorConfig)configuration), streamResultBuilder);
    }

    public <RESULT> Stream<RESULT> harmonicCentrality(GraphName graphName, HarmonicCentralityStreamConfig configuration, StreamResultBuilder<HarmonicResult, RESULT> streamResultBuilder) {
        return this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.HarmonicCentrality, this.estimationFacade::harmonicCentrality, (graph, __) -> this.centralityAlgorithms.harmonicCentrality(graph, (AlgoBaseConfig)configuration), streamResultBuilder);
    }

    public <RESULT> Stream<RESULT> pageRank(GraphName graphName, PageRankStreamConfig configuration, StreamResultBuilder<PageRankResult, RESULT> streamResultBuilder) {
        return this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.PageRank, this.estimationFacade::pageRank, (graph, __) -> this.centralityAlgorithms.pageRank(graph, (PageRankConfig)configuration), streamResultBuilder);
    }

    public <RESULT> Stream<RESULT> hits(GraphName graphName, HitsConfig configuration, StreamResultBuilder<PregelResult, RESULT> streamResultBuilder) {
        HitsETLHook hitsETLHook = this.hitsHookGenerator.createETLHook(configuration);
        return this.algorithmProcessingTemplateConvenience.processAlgorithmInStreamMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.HITS, this.estimationFacade::hits, (graph, __) -> this.centralityAlgorithms.hits(graph, configuration), streamResultBuilder, Optional.empty(), Optional.of(List.of(hitsETLHook)), Optional.empty());
    }
}

