/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import com.carrotsearch.hppc.BitSet;
import java.util.List;
import java.util.Optional;
import org.neo4j.gds.algorithms.centrality.CentralityAlgorithmResult;
import org.neo4j.gds.api.GraphName;
import org.neo4j.gds.applications.algorithms.centrality.ArticulationPointsWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.BetweennessCentralityWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.CelfWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithms;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsEstimationModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.ClosenessCentralityWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.DegreeCentralityWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.HarmonicCentralityWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.HitsETLHook;
import org.neo4j.gds.applications.algorithms.centrality.HitsHookGenerator;
import org.neo4j.gds.applications.algorithms.centrality.HitsWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.PageRankWriteStep;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmLabel;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmProcessingTemplateConvenience;
import org.neo4j.gds.applications.algorithms.machinery.Label;
import org.neo4j.gds.applications.algorithms.machinery.RequestScopedDependencies;
import org.neo4j.gds.applications.algorithms.machinery.ResultBuilder;
import org.neo4j.gds.applications.algorithms.machinery.WriteContext;
import org.neo4j.gds.applications.algorithms.machinery.WriteStep;
import org.neo4j.gds.applications.algorithms.machinery.WriteToDatabase;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.articulationpoints.ArticulationPointsWriteConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityWriteConfig;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.closeness.ClosenessCentralityWriteConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityWriteConfig;
import org.neo4j.gds.harmonic.HarmonicCentralityWriteConfig;
import org.neo4j.gds.harmonic.HarmonicResult;
import org.neo4j.gds.hits.HitsConfig;
import org.neo4j.gds.influenceMaximization.CELFResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationWriteConfig;
import org.neo4j.gds.logging.Log;
import org.neo4j.gds.pagerank.ArticleRankConfig;
import org.neo4j.gds.pagerank.ArticleRankWriteConfig;
import org.neo4j.gds.pagerank.EigenvectorConfig;
import org.neo4j.gds.pagerank.EigenvectorWriteConfig;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankWriteConfig;

public final class CentralityAlgorithmsWriteModeBusinessFacade {
    private final CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade;
    private final CentralityAlgorithms centralityAlgorithms;
    private final AlgorithmProcessingTemplateConvenience algorithmProcessingTemplateConvenience;
    private final WriteToDatabase writeToDatabase;
    private final HitsHookGenerator hitsHookGenerator;

    private CentralityAlgorithmsWriteModeBusinessFacade(CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade, CentralityAlgorithms centralityAlgorithms, AlgorithmProcessingTemplateConvenience algorithmProcessingTemplateConvenience, WriteToDatabase writeToDatabase, HitsHookGenerator hitsHookGenerator) {
        this.estimationFacade = estimationFacade;
        this.centralityAlgorithms = centralityAlgorithms;
        this.algorithmProcessingTemplateConvenience = algorithmProcessingTemplateConvenience;
        this.writeToDatabase = writeToDatabase;
        this.hitsHookGenerator = hitsHookGenerator;
    }

    public static CentralityAlgorithmsWriteModeBusinessFacade create(Log log, RequestScopedDependencies requestScopedDependencies, WriteContext writeContext, CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade, CentralityAlgorithms centralityAlgorithms, AlgorithmProcessingTemplateConvenience algorithmProcessingTemplateConvenience, HitsHookGenerator hitsHookGenerator) {
        WriteToDatabase writeToDatabase = new WriteToDatabase(log, requestScopedDependencies, writeContext);
        return new CentralityAlgorithmsWriteModeBusinessFacade(estimationFacade, centralityAlgorithms, algorithmProcessingTemplateConvenience, writeToDatabase, hitsHookGenerator);
    }

    public <RESULT> RESULT articleRank(GraphName graphName, ArticleRankWriteConfig configuration, ResultBuilder<ArticleRankWriteConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankWriteStep<ArticleRankWriteConfig> writeStep = new PageRankWriteStep<ArticleRankWriteConfig>(this.writeToDatabase, configuration, (Label)AlgorithmLabel.ArticleRank);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInWriteMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ArticleRank, this.estimationFacade::pageRank, (graph, __) -> this.centralityAlgorithms.articleRank(graph, (ArticleRankConfig)configuration), writeStep, resultBuilder);
    }

    public <RESULT> RESULT betweennessCentrality(GraphName graphName, BetweennessCentralityWriteConfig configuration, ResultBuilder<BetweennessCentralityWriteConfig, CentralityAlgorithmResult, RESULT, NodePropertiesWritten> resultBuilder) {
        BetweennessCentralityWriteStep writeStep = new BetweennessCentralityWriteStep(this.writeToDatabase, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInWriteMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.BetweennessCentrality, () -> this.estimationFacade.betweennessCentrality((RelationshipWeightConfig)configuration), (graph, __) -> this.centralityAlgorithms.betweennessCentrality(graph, (BetweennessCentralityBaseConfig)configuration), (WriteStep)writeStep, resultBuilder);
    }

    public <RESULT> RESULT articulationPoints(GraphName graphName, ArticulationPointsWriteConfig configuration, ResultBuilder<ArticulationPointsWriteConfig, BitSet, RESULT, NodePropertiesWritten> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInWriteMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ArticulationPoints, this.estimationFacade::articulationPoints, (graph, __) -> this.centralityAlgorithms.articulationPoints(graph, (AlgoBaseConfig)configuration), (WriteStep)new ArticulationPointsWriteStep(configuration, this.writeToDatabase), resultBuilder);
    }

    public <CONFIGURATION extends InfluenceMaximizationWriteConfig, RESULT> RESULT celf(GraphName graphName, CONFIGURATION configuration, ResultBuilder<CONFIGURATION, CELFResult, RESULT, NodePropertiesWritten> resultBuilder) {
        CelfWriteStep writeStep = new CelfWriteStep(this.writeToDatabase, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInWriteMode(graphName, configuration, (Label)AlgorithmLabel.CELF, () -> this.estimationFacade.celf((InfluenceMaximizationBaseConfig)configuration), (graph, __) -> this.centralityAlgorithms.celf(graph, (InfluenceMaximizationBaseConfig)configuration), (WriteStep)writeStep, resultBuilder);
    }

    public <RESULT> RESULT closenessCentrality(GraphName graphName, ClosenessCentralityWriteConfig configuration, ResultBuilder<ClosenessCentralityWriteConfig, CentralityAlgorithmResult, RESULT, NodePropertiesWritten> resultBuilder) {
        ClosenessCentralityWriteStep writeStep = new ClosenessCentralityWriteStep(this.writeToDatabase, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInWriteMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.ClosenessCentrality, () -> this.estimationFacade.closenessCentrality((ClosenessCentralityBaseConfig)configuration), (graph, __) -> this.centralityAlgorithms.closenessCentrality(graph, (ClosenessCentralityBaseConfig)configuration), (WriteStep)writeStep, resultBuilder);
    }

    public <RESULT> RESULT degreeCentrality(GraphName graphName, DegreeCentralityWriteConfig configuration, ResultBuilder<DegreeCentralityWriteConfig, CentralityAlgorithmResult, RESULT, NodePropertiesWritten> resultBuilder) {
        DegreeCentralityWriteStep writeStep = new DegreeCentralityWriteStep(this.writeToDatabase, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInWriteMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.DegreeCentrality, () -> this.estimationFacade.degreeCentrality((RelationshipWeightConfig)configuration), (graph, __) -> this.centralityAlgorithms.degreeCentrality(graph, (DegreeCentralityConfig)configuration), (WriteStep)writeStep, resultBuilder);
    }

    public <RESULT> RESULT eigenvector(GraphName graphName, EigenvectorWriteConfig configuration, ResultBuilder<EigenvectorWriteConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankWriteStep<EigenvectorWriteConfig> writeStep = new PageRankWriteStep<EigenvectorWriteConfig>(this.writeToDatabase, configuration, (Label)AlgorithmLabel.EigenVector);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInWriteMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.EigenVector, this.estimationFacade::pageRank, (graph, __) -> this.centralityAlgorithms.eigenVector(graph, (EigenvectorConfig)configuration), writeStep, resultBuilder);
    }

    public <CONFIGURATION extends HarmonicCentralityWriteConfig, RESULT> RESULT harmonicCentrality(GraphName graphName, CONFIGURATION configuration, ResultBuilder<CONFIGURATION, HarmonicResult, RESULT, NodePropertiesWritten> resultBuilder) {
        HarmonicCentralityWriteStep writeStep = new HarmonicCentralityWriteStep(this.writeToDatabase, configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInWriteMode(graphName, configuration, (Label)AlgorithmLabel.HarmonicCentrality, this.estimationFacade::harmonicCentrality, (graph, __) -> this.centralityAlgorithms.harmonicCentrality(graph, (AlgoBaseConfig)configuration), (WriteStep)writeStep, resultBuilder);
    }

    public <RESULT> RESULT pageRank(GraphName graphName, PageRankWriteConfig configuration, ResultBuilder<PageRankWriteConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankWriteStep<PageRankWriteConfig> writeStep = new PageRankWriteStep<PageRankWriteConfig>(this.writeToDatabase, configuration, (Label)AlgorithmLabel.ArticleRank);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processRegularAlgorithmInWriteMode(graphName, (AlgoBaseConfig)configuration, (Label)AlgorithmLabel.PageRank, this.estimationFacade::pageRank, (graph, __) -> this.centralityAlgorithms.pageRank(graph, (PageRankConfig)configuration), writeStep, resultBuilder);
    }

    public <RESULT> RESULT hits(GraphName graphName, HitsConfig configuration, ResultBuilder<HitsConfig, PregelResult, RESULT, NodePropertiesWritten> resultBuilder) {
        HitsWriteStep writeStep = new HitsWriteStep(this.writeToDatabase, configuration, (Label)AlgorithmLabel.HITS);
        HitsETLHook hitsETLHook = this.hitsHookGenerator.createETLHook(configuration);
        return (RESULT)this.algorithmProcessingTemplateConvenience.processAlgorithmInWriteMode(Optional.empty(), graphName, (AlgoBaseConfig)configuration, Optional.empty(), Optional.of(List.of(hitsETLHook)), (Label)AlgorithmLabel.HITS, this.estimationFacade::hits, (graph, __) -> this.centralityAlgorithms.hits(graph, configuration), (WriteStep)writeStep, resultBuilder);
    }
}

